/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.convert.impl;

import com.github.jarvisframework.tool.core.collection.CollectionUtils;
import com.github.jarvisframework.tool.core.convert.Converter;
import com.github.jarvisframework.tool.core.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Collection;

public class CollectionConverter
implements Converter<Collection<?>> {
    private final Type collectionType;
    private final Type elementType;

    public CollectionConverter() {
        this(Collection.class);
    }

    public CollectionConverter(Type collectionType) {
        this(collectionType, TypeUtils.getTypeArgument(collectionType));
    }

    public CollectionConverter(Class<?> collectionType) {
        this(collectionType, TypeUtils.getTypeArgument(collectionType));
    }

    public CollectionConverter(Type collectionType, Type elementType) {
        this.collectionType = collectionType;
        this.elementType = elementType;
    }

    @Override
    public Collection<?> convert(Object value, Collection<?> defaultValue) throws IllegalArgumentException {
        Collection<?> result;
        try {
            result = this.convertInternal(value);
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
        return null == result ? defaultValue : result;
    }

    protected Collection<?> convertInternal(Object value) {
        Collection collection = CollectionUtils.create(TypeUtils.getClass(this.collectionType));
        return CollectionUtils.addAll(collection, value, this.elementType);
    }
}

