/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.convert.impl;

import com.github.jarvisframework.tool.core.convert.AbstractConverter;
import com.github.jarvisframework.tool.core.map.MapUtils;
import com.github.jarvisframework.tool.core.util.ClassUtils;
import com.github.jarvisframework.tool.core.util.EnumUtils;
import com.github.jarvisframework.tool.core.util.ModifierUtils;
import com.github.jarvisframework.tool.core.util.ReflectUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class EnumConverter
extends AbstractConverter<Object> {
    private static final long serialVersionUID = 1L;
    private static final Map<Class<?>, Map<Class<?>, Method>> VALUE_OF_METHOD_CACHE = new ConcurrentHashMap();
    private final Class enumClass;

    public EnumConverter(Class enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    protected Object convertInternal(Object value) {
        Enum enumValue = EnumConverter.tryConvertEnum(value, this.enumClass);
        if (null == enumValue && !(value instanceof String)) {
            enumValue = Enum.valueOf(this.enumClass, this.convertToStr(value));
        }
        return enumValue;
    }

    @Override
    public Class getTargetType() {
        return this.enumClass;
    }

    protected static Enum tryConvertEnum(Object value, Class enumClass) {
        Map<Class<?>, Method> valueOfMethods;
        Enum enumResult = null;
        if (value instanceof Integer) {
            enumResult = (Enum)EnumUtils.getEnumAt(enumClass, (Integer)value);
        } else if (value instanceof String) {
            try {
                enumResult = (Enum)Enum.valueOf(enumClass, (String)value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (null == enumResult && MapUtils.isNotEmpty(valueOfMethods = EnumConverter.getValueOfMethods(enumClass))) {
            Class<?> valueClass = value.getClass();
            for (Map.Entry<Class<?>, Method> entry : valueOfMethods.entrySet()) {
                if (!ClassUtils.isAssignable(entry.getKey(), valueClass)) continue;
                enumResult = (Enum)ReflectUtils.invokeStatic(entry.getValue(), value);
            }
        }
        return enumResult;
    }

    private static Map<Class<?>, Method> getValueOfMethods(Class<?> enumClass) {
        Map<Class<?>, Method> valueOfMethods = VALUE_OF_METHOD_CACHE.get(enumClass);
        if (null == valueOfMethods) {
            valueOfMethods = Arrays.stream(enumClass.getMethods()).filter(ModifierUtils::isStatic).filter(m -> m.getReturnType() == enumClass).filter(m -> m.getParameterCount() == 1).filter(m -> false == "valueOf".equals(m.getName())).collect(Collectors.toMap(m -> m.getParameterTypes()[0], m -> m, (existing, replacement) -> existing));
            VALUE_OF_METHOD_CACHE.put(enumClass, valueOfMethods);
        }
        return valueOfMethods;
    }
}

