/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.convert.impl;

import com.github.jarvisframework.tool.core.bean.BeanUtils;
import com.github.jarvisframework.tool.core.convert.AbstractConverter;
import com.github.jarvisframework.tool.core.convert.ConverterRegistry;
import com.github.jarvisframework.tool.core.map.MapUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.core.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

public class MapConverter
extends AbstractConverter<Map<?, ?>> {
    private static final long serialVersionUID = 1L;
    private final Type mapType;
    private final Type keyType;
    private final Type valueType;

    public MapConverter(Type mapType) {
        this(mapType, TypeUtils.getTypeArgument(mapType, 0), TypeUtils.getTypeArgument(mapType, 1));
    }

    public MapConverter(Type mapType, Type keyType, Type valueType) {
        this.mapType = mapType;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    protected Map<?, ?> convertInternal(Object value) {
        Map<Object, Object> map;
        if (value instanceof Map) {
            Type[] typeArguments = TypeUtils.getTypeArguments(value.getClass());
            if (null != typeArguments && 2 == typeArguments.length && Objects.equals(this.keyType, typeArguments[0]) && Objects.equals(this.valueType, typeArguments[1])) {
                return (Map)value;
            }
            map = MapUtils.createMap(TypeUtils.getClass(this.mapType));
            this.convertMapToMap((Map)value, map);
        } else if (BeanUtils.isBean(value.getClass())) {
            map = BeanUtils.beanToMap(value);
            map = this.convertInternal(map);
        } else {
            throw new UnsupportedOperationException(StringUtils.format((CharSequence)"Unsupport toMap value type: {}", value.getClass().getName()));
        }
        return map;
    }

    private void convertMapToMap(Map<?, ?> srcMap, Map<Object, Object> targetMap) {
        ConverterRegistry convert = ConverterRegistry.getInstance();
        for (Map.Entry<?, ?> entry : srcMap.entrySet()) {
            Object key = TypeUtils.isUnknown(this.keyType) ? entry.getKey() : convert.convert(this.keyType, entry.getKey());
            Object value = TypeUtils.isUnknown(this.valueType) ? entry.getValue() : convert.convert(this.valueType, entry.getValue());
            targetMap.put(key, value);
        }
    }

    @Override
    public Class<Map<?, ?>> getTargetType() {
        return TypeUtils.getClass(this.mapType);
    }
}

