/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.convert.impl;

import com.github.jarvisframework.tool.core.convert.AbstractConverter;
import com.github.jarvisframework.tool.core.convert.ConverterRegistry;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.core.util.TypeUtils;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;

public class ReferenceConverter
extends AbstractConverter<Reference> {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Reference> targetType;

    public ReferenceConverter(Class<? extends Reference> targetType) {
        this.targetType = targetType;
    }

    @Override
    protected Reference<?> convertInternal(Object value) {
        Object targetValue = null;
        Type paramType = TypeUtils.getTypeArgument(this.targetType);
        if (!TypeUtils.isUnknown(paramType)) {
            targetValue = ConverterRegistry.getInstance().convert(paramType, value);
        }
        if (null == targetValue) {
            targetValue = value;
        }
        if (this.targetType == WeakReference.class) {
            return new WeakReference<Object>(targetValue);
        }
        if (this.targetType == SoftReference.class) {
            return new SoftReference<Object>(targetValue);
        }
        throw new UnsupportedOperationException(StringUtils.format((CharSequence)"Unsupport Reference type: {}", this.targetType.getName()));
    }
}

