/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.date;

import com.github.jarvisframework.tool.core.comparator.CompareUtils;
import com.github.jarvisframework.tool.core.date.DateFieldEnum;
import com.github.jarvisframework.tool.core.date.DateModifier;
import com.github.jarvisframework.tool.core.date.DateTime;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;

public class CalendarUtils {
    public static Calendar calendar() {
        return Calendar.getInstance();
    }

    public static Calendar calendar(Date date) {
        if (date instanceof DateTime) {
            return ((DateTime)date).toCalendar();
        }
        return CalendarUtils.calendar(date.getTime());
    }

    public static Calendar calendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static boolean isAM(Calendar calendar) {
        return 0 == calendar.get(9);
    }

    public static boolean isPm(Calendar calendar) {
        return 1 == calendar.get(9);
    }

    public static Calendar truncate(Calendar calendar, DateFieldEnum dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier.ModifyType.TRUNCATE);
    }

    public static Calendar round(Calendar calendar, DateFieldEnum dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier.ModifyType.ROUND);
    }

    public static Calendar ceiling(Calendar calendar, DateFieldEnum dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier.ModifyType.CEILING);
    }

    public static Calendar beginOfSecond(Calendar calendar) {
        return CalendarUtils.truncate(calendar, DateFieldEnum.SECOND);
    }

    public static Calendar endOfSecond(Calendar calendar) {
        return CalendarUtils.ceiling(calendar, DateFieldEnum.SECOND);
    }

    public static Calendar beginOfDay(Calendar calendar) {
        return CalendarUtils.truncate(calendar, DateFieldEnum.DAY_OF_MONTH);
    }

    public static Calendar endOfDay(Calendar calendar) {
        return CalendarUtils.ceiling(calendar, DateFieldEnum.DAY_OF_MONTH);
    }

    public static Calendar beginOfWeek(Calendar calendar) {
        return CalendarUtils.beginOfWeek(calendar, true);
    }

    public static Calendar beginOfWeek(Calendar calendar, boolean isMondayAsFirstDay) {
        calendar.setFirstDayOfWeek(isMondayAsFirstDay ? 2 : 1);
        return CalendarUtils.truncate(calendar, DateFieldEnum.WEEK_OF_MONTH);
    }

    public static Calendar endOfWeek(Calendar calendar) {
        return CalendarUtils.endOfWeek(calendar, true);
    }

    public static Calendar endOfWeek(Calendar calendar, boolean isSundayAsLastDay) {
        calendar.setFirstDayOfWeek(isSundayAsLastDay ? 2 : 1);
        return CalendarUtils.ceiling(calendar, DateFieldEnum.WEEK_OF_MONTH);
    }

    public static Calendar beginOfMonth(Calendar calendar) {
        return CalendarUtils.truncate(calendar, DateFieldEnum.MONTH);
    }

    public static Calendar endOfMonth(Calendar calendar) {
        return CalendarUtils.ceiling(calendar, DateFieldEnum.MONTH);
    }

    public static Calendar beginOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(DateFieldEnum.MONTH.getValue()) / 3 * 3);
        calendar.set(5, 1);
        return CalendarUtils.beginOfDay(calendar);
    }

    public static Calendar endOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(DateFieldEnum.MONTH.getValue()) / 3 * 3 + 2);
        calendar.set(5, calendar.getActualMaximum(5));
        return CalendarUtils.endOfDay(calendar);
    }

    public static Calendar beginOfYear(Calendar calendar) {
        return CalendarUtils.truncate(calendar, DateFieldEnum.YEAR);
    }

    public static Calendar endOfYear(Calendar calendar) {
        return CalendarUtils.ceiling(calendar, DateFieldEnum.YEAR);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1) && cal1.get(0) == cal2.get(0);
    }

    public static LinkedHashSet<String> yearAndQuarter(long startDate, long endDate) {
        LinkedHashSet<String> quarters = new LinkedHashSet<String>();
        Calendar cal = CalendarUtils.calendar(startDate);
        while (startDate <= endDate) {
            quarters.add(CalendarUtils.yearAndQuarter(cal));
            cal.add(2, 3);
            startDate = cal.getTimeInMillis();
        }
        return quarters;
    }

    public static String yearAndQuarter(Calendar cal) {
        return StringUtils.builder().append(cal.get(1)).append(cal.get(2) / 3 + 1).toString();
    }

    public static int getBeginValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return calendar.getFirstDayOfWeek();
        }
        return calendar.getActualMinimum(dateField);
    }

    public static int getEndValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return (calendar.getFirstDayOfWeek() + 6) % 7;
        }
        return calendar.getActualMaximum(dateField);
    }

    public static Instant toInstant(Calendar calendar) {
        return null == calendar ? null : calendar.toInstant();
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar) {
        return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
    }

    public static int compare(Calendar calendar1, Calendar calendar2) {
        return CompareUtils.compare(calendar1, calendar2);
    }

    public static int age(Calendar birthday, Calendar dateToCompare) {
        return CalendarUtils.age(birthday.getTimeInMillis(), dateToCompare.getTimeInMillis());
    }

    protected static int age(long birthday, long dateToCompare) {
        if (birthday > dateToCompare) {
            throw new IllegalArgumentException("Birthday is after dateToCompare!");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dateToCompare);
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        boolean isLastDayOfMonth = dayOfMonth == cal.getActualMaximum(5);
        cal.setTimeInMillis(birthday);
        int age = year - cal.get(1);
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            boolean isLastDayOfMonthBirth;
            int dayOfMonthBirth = cal.get(5);
            boolean bl = isLastDayOfMonthBirth = dayOfMonthBirth == cal.getActualMaximum(5);
            if (!(isLastDayOfMonth && isLastDayOfMonthBirth || dayOfMonth >= dayOfMonthBirth)) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }
}

