/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.date;

import com.github.jarvisframework.tool.core.date.BetweenFormat;
import com.github.jarvisframework.tool.core.date.DateBetween;
import com.github.jarvisframework.tool.core.date.DateException;
import com.github.jarvisframework.tool.core.date.DateFieldEnum;
import com.github.jarvisframework.tool.core.date.DatePattern;
import com.github.jarvisframework.tool.core.date.DateUnitEnum;
import com.github.jarvisframework.tool.core.date.DateUtils;
import com.github.jarvisframework.tool.core.date.MonthEnum;
import com.github.jarvisframework.tool.core.date.QuarterEnum;
import com.github.jarvisframework.tool.core.date.WeekEnum;
import com.github.jarvisframework.tool.core.date.format.DateParser;
import com.github.jarvisframework.tool.core.date.format.DatePrinter;
import com.github.jarvisframework.tool.core.date.format.FastDateFormat;
import com.github.jarvisframework.tool.core.lang.Assert;
import com.github.jarvisframework.tool.core.util.ObjectUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateTime
extends java.util.Date {
    private static final long serialVersionUID = -5395712593979185936L;
    private boolean mutable = true;
    private WeekEnum firstDayOfWeek = WeekEnum.MONDAY;
    private TimeZone timeZone;

    public static DateTime of(long timeMillis) {
        return new DateTime(timeMillis);
    }

    public static DateTime of(java.util.Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return new DateTime(date);
    }

    public static DateTime of(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime of(String dateStr, String format) {
        return new DateTime((CharSequence)dateStr, format);
    }

    public static DateTime now() {
        return new DateTime();
    }

    public DateTime() {
        this(TimeZone.getDefault());
    }

    public DateTime(TimeZone timeZone) {
        this(System.currentTimeMillis(), timeZone);
    }

    public DateTime(java.util.Date date) {
        this(date.getTime(), date instanceof DateTime ? ((DateTime)date).timeZone : TimeZone.getDefault());
    }

    public DateTime(java.util.Date date, TimeZone timeZone) {
        this(date.getTime(), timeZone);
    }

    public DateTime(Calendar calendar) {
        this(calendar.getTime(), calendar.getTimeZone());
        this.setFirstDayOfWeek(WeekEnum.of(calendar.getFirstDayOfWeek()));
    }

    public DateTime(Instant instant) {
        this(instant.toEpochMilli());
    }

    public DateTime(Instant instant, ZoneId zoneId) {
        this(instant.toEpochMilli(), TimeZone.getTimeZone(ObjectUtils.defaultIfNull(zoneId, ZoneId.systemDefault())));
    }

    public DateTime(TemporalAccessor temporalAccessor) {
        this(DateUtils.toInstant(temporalAccessor));
    }

    public DateTime(ZonedDateTime zonedDateTime) {
        this(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    public DateTime(long timeMillis) {
        this(timeMillis, TimeZone.getDefault());
    }

    public DateTime(long timeMillis, TimeZone timeZone) {
        super(timeMillis);
        this.timeZone = ObjectUtils.defaultIfNull(timeZone, TimeZone.getDefault());
    }

    public DateTime(CharSequence dateStr, String format) {
        this(dateStr, new SimpleDateFormat(format));
    }

    public DateTime(CharSequence dateStr, DateFormat dateFormat) {
        this(DateTime.parse(dateStr, dateFormat), dateFormat.getTimeZone());
    }

    public DateTime(CharSequence dateStr, DateTimeFormatter formatter) {
        this(Instant.from(formatter.parse(dateStr)), formatter.getZone());
    }

    public DateTime(CharSequence dateStr, DateParser dateParser) {
        this(DateTime.parse(dateStr, dateParser), dateParser.getTimeZone());
    }

    public DateTime offset(DateFieldEnum datePart, int offset) {
        if (DateFieldEnum.ERA == datePart) {
            throw new IllegalArgumentException("ERA is not support offset!");
        }
        Calendar cal = this.toCalendar();
        cal.add(datePart.getValue(), offset);
        DateTime dt = this.mutable ? this : ObjectUtils.clone(this);
        return dt.setTimeInternal(cal.getTimeInMillis());
    }

    public DateTime offsetNew(DateFieldEnum datePart, int offset) {
        Calendar cal = this.toCalendar();
        cal.add(datePart.getValue(), offset);
        DateTime dt = ObjectUtils.clone(this);
        return dt.setTimeInternal(cal.getTimeInMillis());
    }

    public int getField(DateFieldEnum field) {
        return this.getField(field.getValue());
    }

    public int getField(int field) {
        return this.toCalendar().get(field);
    }

    public DateTime setField(DateFieldEnum field, int value) {
        return this.setField(field.getValue(), value);
    }

    public DateTime setField(int field, int value) {
        Calendar calendar = this.toCalendar();
        calendar.set(field, value);
        DateTime dt = this;
        if (!this.mutable) {
            dt = ObjectUtils.clone(this);
        }
        return dt.setTimeInternal(calendar.getTimeInMillis());
    }

    @Override
    public void setTime(long time) {
        if (!this.mutable) {
            throw new DateException("This is not a mutable object !");
        }
        super.setTime(time);
    }

    public int year() {
        return this.getField(DateFieldEnum.YEAR);
    }

    public int quarter() {
        return this.month() / 3 + 1;
    }

    public QuarterEnum quarterEnum() {
        return QuarterEnum.of(this.quarter());
    }

    public int month() {
        return this.getField(DateFieldEnum.MONTH);
    }

    public int monthStartFromOne() {
        return this.month() + 1;
    }

    public MonthEnum monthEnum() {
        return MonthEnum.of(this.month());
    }

    public int weekOfYear() {
        return this.getField(DateFieldEnum.WEEK_OF_YEAR);
    }

    public int weekOfMonth() {
        return this.getField(DateFieldEnum.WEEK_OF_MONTH);
    }

    public int dayOfMonth() {
        return this.getField(DateFieldEnum.DAY_OF_MONTH);
    }

    public int dayOfYear() {
        return this.getField(DateFieldEnum.DAY_OF_YEAR);
    }

    public int dayOfWeek() {
        return this.getField(DateFieldEnum.DAY_OF_WEEK);
    }

    public int dayOfWeekInMonth() {
        return this.getField(DateFieldEnum.DAY_OF_WEEK_IN_MONTH);
    }

    public WeekEnum dayOfWeekEnum() {
        return WeekEnum.of(this.dayOfWeek());
    }

    public int hour(boolean is24HourClock) {
        return this.getField(is24HourClock ? DateFieldEnum.HOUR_OF_DAY : DateFieldEnum.HOUR);
    }

    public int minute() {
        return this.getField(DateFieldEnum.MINUTE);
    }

    public int second() {
        return this.getField(DateFieldEnum.SECOND);
    }

    public int millisecond() {
        return this.getField(DateFieldEnum.MILLISECOND);
    }

    @Deprecated
    public int millsecond() {
        return this.getField(DateFieldEnum.MILLISECOND);
    }

    public boolean isAM() {
        return 0 == this.getField(DateFieldEnum.AM_PM);
    }

    public boolean isPM() {
        return 1 == this.getField(DateFieldEnum.AM_PM);
    }

    public boolean isWeekend() {
        int dayOfWeek = this.dayOfWeek();
        return 7 == dayOfWeek || 1 == dayOfWeek;
    }

    public boolean isLeapYear() {
        return DateUtils.isLeapYear(this.year());
    }

    public Calendar toCalendar() {
        return this.toCalendar(Locale.getDefault(Locale.Category.FORMAT));
    }

    public Calendar toCalendar(Locale locale) {
        return this.toCalendar(this.timeZone, locale);
    }

    public Calendar toCalendar(TimeZone zone) {
        return this.toCalendar(zone, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Calendar toCalendar(TimeZone zone, Locale locale) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        Calendar cal = null != zone ? Calendar.getInstance(zone, locale) : Calendar.getInstance(locale);
        cal.setFirstDayOfWeek(this.firstDayOfWeek.getValue());
        cal.setTime(this);
        return cal;
    }

    public java.util.Date toJdkDate() {
        return new java.util.Date(this.getTime());
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.getTime());
    }

    public Date toSqlDate() {
        return new Date(this.getTime());
    }

    public DateBetween between(java.util.Date date) {
        return new DateBetween(this, date);
    }

    public long between(java.util.Date date, DateUnitEnum unit) {
        return new DateBetween(this, date).between(unit);
    }

    public String between(java.util.Date date, DateUnitEnum unit, BetweenFormat.Level formatLevel) {
        return new DateBetween(this, date).toString(formatLevel);
    }

    public boolean isIn(java.util.Date beginDate, java.util.Date endDate) {
        long beginMills = beginDate.getTime();
        long endMills = endDate.getTime();
        long thisMills = this.getTime();
        return thisMills >= Math.min(beginMills, endMills) && thisMills <= Math.max(beginMills, endMills);
    }

    public boolean isBefore(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) < 0;
    }

    public boolean isBeforeOrEquals(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) <= 0;
    }

    public boolean isAfter(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) > 0;
    }

    public boolean isAfterOrEquals(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) >= 0;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public DateTime setMutable(boolean mutable) {
        this.mutable = mutable;
        return this;
    }

    public WeekEnum getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public DateTime setFirstDayOfWeek(WeekEnum firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public ZoneId getZoneId() {
        return this.timeZone.toZoneId();
    }

    public DateTime setTimeZone(TimeZone timeZone) {
        this.timeZone = ObjectUtils.defaultIfNull(timeZone, TimeZone.getDefault());
        return this;
    }

    @Override
    public String toString() {
        return this.toString(this.timeZone);
    }

    public String toStringDefaultTimeZone() {
        return this.toString(TimeZone.getDefault());
    }

    public String toString(TimeZone timeZone) {
        if (null != timeZone) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            simpleDateFormat.setTimeZone(timeZone);
            return this.toString(simpleDateFormat);
        }
        return this.toString(DatePattern.NORM_DATETIME_FORMAT);
    }

    public String toDateStr() {
        if (null != this.timeZone) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            simpleDateFormat.setTimeZone(this.timeZone);
            return this.toString(simpleDateFormat);
        }
        return this.toString(DatePattern.NORM_DATE_FORMAT);
    }

    public String toTimeStr() {
        if (null != this.timeZone) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            simpleDateFormat.setTimeZone(this.timeZone);
            return this.toString(simpleDateFormat);
        }
        return this.toString(DatePattern.NORM_TIME_FORMAT);
    }

    public String toString(String format) {
        if (null != this.timeZone) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
            simpleDateFormat.setTimeZone(this.timeZone);
            return this.toString(simpleDateFormat);
        }
        return this.toString(FastDateFormat.getInstance(format));
    }

    public String toString(DatePrinter format) {
        return format.format(this);
    }

    public String toString(DateFormat format) {
        return format.format(this);
    }

    public String toMsStr() {
        return this.toString(DatePattern.NORM_DATETIME_MS_FORMAT);
    }

    private static java.util.Date parse(CharSequence dateStr, DateFormat dateFormat) {
        Assert.notBlank(dateStr, "Date String must be not blank !", new Object[0]);
        try {
            return dateFormat.parse(dateStr.toString());
        }
        catch (Exception e) {
            String pattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : dateFormat.toString();
            throw new DateException(StringUtils.format((CharSequence)"Parse [{}] with format [{}] error!", dateStr, pattern), e);
        }
    }

    private static java.util.Date parse(CharSequence dateStr, DateParser parser) {
        Assert.notNull(parser, "Parser or DateFromat must be not null !", new Object[0]);
        Assert.notBlank(dateStr, "Date String must be not blank !", new Object[0]);
        try {
            return parser.parse(dateStr.toString());
        }
        catch (Exception e) {
            throw new DateException("Parse [{}] with format [{}] error!", dateStr, parser.getPattern(), e);
        }
    }

    private DateTime setTimeInternal(long time) {
        super.setTime(time);
        return this;
    }
}

