/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.date;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtils {
    public static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = DateTimeFormat.access$000(DateTimeFormat.LONG_DATE_PATTERN_LINE);
    public static final String DEFAULT_DATETIME_PATTERN = DateTimeFormat.access$100(DateTimeFormat.LONG_DATE_PATTERN_LINE);
    public static final String DATE_TIMEZONE = "GMT+8";
    private static ThreadLocal<DateFormat> LOCAL = new ThreadLocal();
    private static final int SECOND_MILLI = 1000;
    private static final long MINUTE_MILLI = 60000L;
    private static final long HOUR_MILLI = 3600000L;
    private static final long DAY_MILLI = 86400000L;
    private static final long MONTH_MILLI = 2678400000L;
    private static final long YEAR_MILLI = 1036800000L;
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String WEEK = "week";
    private static final String DAY = "day";
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String SECOND = "second";
    private static final String MONDAY = "MONDAY";
    private static final String TUESDAY = "TUESDAY";
    private static final String WEDNESDAY = "WEDNESDAY";
    private static final String THURSDAY = "THURSDAY";
    private static final String FRIDAY = "FRIDAY";
    private static final String SATURDAY = "SATURDAY";
    private static final String SUNDAY = "SUNDAY";

    private DateTimeUtils() {
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static LocalDateTime toLocalDateTime(Date time) {
        return LocalDateTime.ofInstant(time.toInstant(), ZoneId.systemDefault());
    }

    public static Date toDate(LocalDateTime time) {
        return Date.from(time.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String getYearBegin(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        return year + "-01-01 00:00:00";
    }

    public static String getYearEnd(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        return year + "-12-31 23:59:00";
    }

    public static Date getDayBegin(Date time) {
        return DateTimeUtils.toDate(DateTimeUtils.toLocalDateTime(time).with(LocalTime.MIN));
    }

    public static Date getDayEnd(Date time) {
        return DateTimeUtils.toDate(DateTimeUtils.toLocalDateTime(time).with(LocalTime.MAX));
    }

    public static int getIntervalDays(Date firstDate, Date secondDate) {
        return (int)(Math.abs(firstDate.getTime() - secondDate.getTime()) / 86400000L);
    }

    public static int getIntervalHours(Date firstDate, Date secondDate) {
        return (int)(Math.abs(firstDate.getTime() - secondDate.getTime()) / 3600000L);
    }

    public static int getIntervalSeconds(Date firstDate, Date secondDate) {
        return (int)(Math.abs(firstDate.getTime() - secondDate.getTime()) / 1000L);
    }

    public static int getIntervalMilliSecond(Date firstDate, Date secondDate) {
        return (int)Math.abs(firstDate.getTime() - secondDate.getTime());
    }

    public static int getIntervalMinutes(Date firstDate, Date secondDate) {
        return (int)(Math.abs(firstDate.getTime() - secondDate.getTime()) / 60000L);
    }

    public static int getQuarter(Date date) {
        int season = -1;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                season = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
                break;
            }
        }
        return season;
    }

    public static Double getSeconds(long nanosecond) {
        BigDecimal seconds = new BigDecimal(nanosecond).divide(new BigDecimal(1000000)).divide(new BigDecimal(1000));
        return seconds.doubleValue();
    }

    public static LocalDateTime parseTime(String timeStr) {
        return LocalDateTime.parse(timeStr, DEFAULT_DATETIME_FORMATTER);
    }

    public static LocalDateTime parseTime(String timeStr, DateTimeFormat format) {
        return LocalDateTime.parse(timeStr, format.formatter);
    }

    public static String parseTime(LocalDateTime time) {
        return DEFAULT_DATETIME_FORMATTER.format(time);
    }

    public static String parseTime(LocalDateTime time, DateTimeFormat dateTimeFormat) {
        return dateTimeFormat.formatter.format(time);
    }

    public static String getCurrentDateTime() {
        return DEFAULT_DATETIME_FORMATTER.format(LocalDateTime.now());
    }

    public static String getCurrentDateTime(DateTimeFormat dateTimeFormat) {
        return dateTimeFormat.formatter.format(LocalDateTime.now());
    }

    public static String parseTime(Date time) {
        return DateTimeUtils.parseTime(time, DEFAULT_DATETIME_PATTERN);
    }

    public static String parseTime(Date time, String pattern) {
        DateFormat formatter = LOCAL.get();
        if (null == formatter) {
            formatter = new SimpleDateFormat(pattern);
        }
        return formatter.format(time);
    }

    public static Date _parseTime(String timeStr) {
        return DateTimeUtils.parseTime(timeStr, DEFAULT_DATETIME_PATTERN);
    }

    public static Date parseTime(String timeStr, String pattern) {
        Date date;
        DateFormat formatter = LOCAL.get();
        if (null == formatter) {
            formatter = new SimpleDateFormat(pattern);
        }
        try {
            date = formatter.parse(timeStr);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public static Date currentTimePlusSecond(long second) {
        return new Date(System.currentTimeMillis() + second * 1000L);
    }

    public static String getDateTimeStrFromCurrentPlusSecond(long second) {
        Date date = DateTimeUtils.currentTimePlusSecond(second);
        return DateTimeUtils.parseTime(date);
    }

    public static enum DateTimeFormat {
        TIME_M_PATTERN("M"),
        TIME_H_PATTERN("H"),
        DATE_D_PATTERN("D"),
        TIME_PATTERN("HH:mm:ss"),
        SHORT_DATE_PATTERN_LINE("yyyy-MM-dd"),
        SHORT_DATE_PATTERN_SLASH("yyyy/MM/dd"),
        SHORT_DATE_PATTERN_DOUBLE_SLASH("yyyy\\MM\\dd"),
        SHORT_DATE_PATTERN_CN("yyyy\u5e74MM\u6708dd\u65e5"),
        SHORT_DATE_PATTERN_NONE("yyyyMMdd"),
        LONG_DATE_PATTERN_LINE("yyyy-MM-dd HH:mm:ss"),
        LONG_DATE_PATTERN_SLASH("yyyy/MM/dd HH:mm:ss"),
        LONG_DATE_PATTERN_DOUBLE_SLASH("yyyy\\MM\\dd HH:mm:ss"),
        LONG_DATE_PATTERN_CN("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2"),
        LONG_DATE_PATTERN_NONE("yyyyMMdd HH:mm:ss"),
        LONG_DATE_PATTERN_WITH_MILSEC_LINE("yyyy-MM-dd HH:mm:ss.SSS"),
        LONG_DATE_PATTERN_WITH_MILSEC_SLASH("yyyy/MM/dd HH:mm:ss.SSS"),
        LONG_DATE_PATTERN_WITH_MILSEC_DOUBLE_SLASH("yyyy\\MM\\dd HH:mm:ss.SSS"),
        LONG_DATE_PATTERN_WITH_MILSEC_NONE("yyyyMMdd HH:mm:ss.SSS"),
        DAYTIME_START("00:00:00"),
        DAYTIME_END("23:59:59");

        private transient DateTimeFormatter formatter;
        private String pattern;

        private DateTimeFormat(String pattern) {
            this.pattern = pattern;
            this.formatter = DateTimeFormatter.ofPattern(pattern);
        }

        public String getPattern() {
            return this.pattern;
        }

        static /* synthetic */ String access$100(DateTimeFormat x0) {
            return x0.pattern;
        }
    }
}

