/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.date;

import com.github.jarvisframework.tool.core.collection.CollectionUtils;
import com.github.jarvisframework.tool.core.comparator.CompareUtils;
import com.github.jarvisframework.tool.core.convert.Convert;
import com.github.jarvisframework.tool.core.date.BetweenFormat;
import com.github.jarvisframework.tool.core.date.CalendarUtils;
import com.github.jarvisframework.tool.core.date.DateBetween;
import com.github.jarvisframework.tool.core.date.DateException;
import com.github.jarvisframework.tool.core.date.DateFieldEnum;
import com.github.jarvisframework.tool.core.date.DatePattern;
import com.github.jarvisframework.tool.core.date.DateRange;
import com.github.jarvisframework.tool.core.date.DateTime;
import com.github.jarvisframework.tool.core.date.DateUnitEnum;
import com.github.jarvisframework.tool.core.date.MonthEnum;
import com.github.jarvisframework.tool.core.date.QuarterEnum;
import com.github.jarvisframework.tool.core.date.StopWatch;
import com.github.jarvisframework.tool.core.date.TimeInterval;
import com.github.jarvisframework.tool.core.date.WeekEnum;
import com.github.jarvisframework.tool.core.date.Zodiac;
import com.github.jarvisframework.tool.core.date.format.DateParser;
import com.github.jarvisframework.tool.core.date.format.DatePrinter;
import com.github.jarvisframework.tool.core.lang.Assert;
import com.github.jarvisframework.tool.core.lang.PatternPool;
import com.github.jarvisframework.tool.core.text.StringBuilder;
import com.github.jarvisframework.tool.core.util.NumberUtils;
import com.github.jarvisframework.tool.core.util.RegexUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;

public class DateUtils
extends CalendarUtils {
    private static final String[] wtb = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime dateSecond() {
        return DateUtils.beginOfSecond(DateUtils.date());
    }

    public static DateTime date(Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return DateUtils.dateNew(date);
    }

    public static DateTime dateNew(Date date) {
        return new DateTime(date);
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime date(TemporalAccessor temporalAccessor) {
        return new DateTime(temporalAccessor);
    }

    public static long current(boolean isNano) {
        return isNano ? System.nanoTime() : System.currentTimeMillis();
    }

    public static long currentSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String now() {
        return DateUtils.formatDateTime(new DateTime());
    }

    public static String today() {
        return DateUtils.formatDate(new DateTime());
    }

    public static int year(Date date) {
        return DateTime.of(date).year();
    }

    public static int quarter(Date date) {
        return DateTime.of(date).quarter();
    }

    public static QuarterEnum quarterEnum(Date date) {
        return DateTime.of(date).quarterEnum();
    }

    public static int month(Date date) {
        return DateTime.of(date).month();
    }

    public static MonthEnum monthEnum(Date date) {
        return DateTime.of(date).monthEnum();
    }

    public static int weekOfYear(Date date) {
        return DateTime.of(date).weekOfYear();
    }

    public static int weekOfMonth(Date date) {
        return DateTime.of(date).weekOfMonth();
    }

    public static int dayOfMonth(Date date) {
        return DateTime.of(date).dayOfMonth();
    }

    public static int dayOfYear(Date date) {
        return DateTime.of(date).dayOfYear();
    }

    public static int dayOfWeek(Date date) {
        return DateTime.of(date).dayOfWeek();
    }

    public static WeekEnum dayOfWeekEnum(Date date) {
        return DateTime.of(date).dayOfWeekEnum();
    }

    public static int hour(Date date, boolean is24HourClock) {
        return DateTime.of(date).hour(is24HourClock);
    }

    public static int minute(Date date) {
        return DateTime.of(date).minute();
    }

    public static int second(Date date) {
        return DateTime.of(date).second();
    }

    public static int millsecond(Date date) {
        return DateTime.of(date).millsecond();
    }

    public static boolean isAM(Date date) {
        return DateTime.of(date).isAM();
    }

    public static boolean isPM(Date date) {
        return DateTime.of(date).isPM();
    }

    public static int thisYear() {
        return DateUtils.year(DateUtils.date());
    }

    public static int thisMonth() {
        return DateUtils.month(DateUtils.date());
    }

    public static MonthEnum thisMonthEnum() {
        return DateUtils.monthEnum(DateUtils.date());
    }

    public static int thisWeekOfYear() {
        return DateUtils.weekOfYear(DateUtils.date());
    }

    public static int thisWeekOfMonth() {
        return DateUtils.weekOfMonth(DateUtils.date());
    }

    public static int thisDayOfMonth() {
        return DateUtils.dayOfMonth(DateUtils.date());
    }

    public static int thisDayOfWeek() {
        return DateUtils.dayOfWeek(DateUtils.date());
    }

    public static WeekEnum thisDayOfWeekEnum() {
        return DateUtils.dayOfWeekEnum(DateUtils.date());
    }

    public static int thisHour(boolean is24HourClock) {
        return DateUtils.hour(DateUtils.date(), is24HourClock);
    }

    public static int thisMinute() {
        return DateUtils.minute(DateUtils.date());
    }

    public static int thisSecond() {
        return DateUtils.second(DateUtils.date());
    }

    public static int thisMillsecond() {
        return DateUtils.millsecond(DateUtils.date());
    }

    public static String yearAndQuarter(Date date) {
        return DateUtils.yearAndQuarter(DateUtils.calendar(date));
    }

    public static LinkedHashSet<String> yearAndQuarter(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return new LinkedHashSet<String>(0);
        }
        return DateUtils.yearAndQuarter(startDate.getTime(), endDate.getTime());
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime) {
        return DateUtils.format(localDateTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(LocalDateTime localDateTime, String format) {
        if (null == localDateTime || StringUtils.isBlank(format)) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        return localDateTime.format(df);
    }

    public static String format(Date date, String format) {
        TimeZone timeZone;
        if (null == date || StringUtils.isBlank(format)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (date instanceof DateTime && null != (timeZone = ((DateTime)date).getTimeZone())) {
            sdf.setTimeZone(timeZone);
        }
        return DateUtils.format(date, sdf);
    }

    public static String format(Date date, DatePrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateTimeFormatter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date.toInstant());
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATETIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATE_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_TIME_FORMAT.format(date);
    }

    public static String formatHttpDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.HTTP_DATETIME_FORMAT.format(date);
    }

    public static String formatChineseDate(Date date, boolean isUppercase) {
        if (null == date) {
            return null;
        }
        String format = DatePattern.CHINESE_DATE_FORMAT.format(date);
        if (isUppercase) {
            StringBuilder builder = StringUtils.builder(format.length());
            builder.append(Convert.numberToChinese(Integer.parseInt(format.substring(0, 1)), false));
            builder.append(Convert.numberToChinese(Integer.parseInt(format.substring(1, 2)), false));
            builder.append(Convert.numberToChinese(Integer.parseInt(format.substring(2, 3)), false));
            builder.append(Convert.numberToChinese(Integer.parseInt(format.substring(3, 4)), false));
            builder.append(format, 4, 5);
            builder.append(Convert.numberToChinese(Integer.parseInt(format.substring(5, 7)), false));
            builder.append(format, 7, 8);
            builder.append(Convert.numberToChinese(Integer.parseInt(format.substring(8, 10)), false));
            builder.append(format.substring(10));
            format = builder.toString().replace('\u96f6', '\u3007');
        }
        return format;
    }

    public static LocalDateTime parseLocalDateTime(CharSequence dateStr) {
        return DateUtils.parseLocalDateTime(dateStr, "yyyy-MM-dd HH:mm:ss");
    }

    public static LocalDateTime parseLocalDateTime(CharSequence dateStr, String format) {
        dateStr = DateUtils.normalize(dateStr);
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        try {
            return LocalDateTime.parse(dateStr, df);
        }
        catch (DateTimeParseException e) {
            return LocalDate.parse(dateStr, df).atStartOfDay();
        }
    }

    public static DateTime parse(CharSequence dateStr, DateFormat dateFormat) {
        return new DateTime(dateStr, dateFormat);
    }

    public static DateTime parse(CharSequence dateStr, DateParser parser) {
        return new DateTime(dateStr, parser);
    }

    public static DateTime parse(CharSequence dateStr, DateTimeFormatter formatter) {
        return new DateTime(dateStr, formatter);
    }

    public static DateTime parse(CharSequence dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime parse(CharSequence dateStr, String format, Locale locale) {
        return new DateTime(dateStr, new SimpleDateFormat(format, locale));
    }

    public static DateTime parseDateTime(CharSequence dateString) {
        dateString = DateUtils.normalize(dateString);
        return DateUtils.parse(dateString, DatePattern.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseDate(CharSequence dateString) {
        dateString = DateUtils.normalize(dateString);
        return DateUtils.parse(dateString, DatePattern.NORM_DATE_FORMAT);
    }

    public static DateTime parseTime(CharSequence timeString) {
        timeString = DateUtils.normalize(timeString);
        return DateUtils.parse(timeString, DatePattern.NORM_TIME_FORMAT);
    }

    public static DateTime parseTimeToday(CharSequence timeString) {
        timeString = StringUtils.format((CharSequence)"{} {}", DateUtils.today(), timeString);
        if (1 == StringUtils.count(timeString, ':')) {
            return DateUtils.parse(timeString, "yyyy-MM-dd HH:mm");
        }
        return DateUtils.parse(timeString, DatePattern.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseUTC(String utcString) {
        if (utcString == null) {
            return null;
        }
        int length = utcString.length();
        if (StringUtils.contains((CharSequence)utcString, 'Z')) {
            if (length == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return DateUtils.parse((CharSequence)utcString, DatePattern.UTC_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length() - 4) {
                return DateUtils.parse((CharSequence)utcString, DatePattern.UTC_MS_FORMAT);
            }
        } else {
            if (length == "yyyy-MM-dd'T'HH:mm:ssZ".length() + 2 || length == "yyyy-MM-dd'T'HH:mm:ssZ".length() + 3) {
                return DateUtils.parse((CharSequence)utcString, DatePattern.UTC_WITH_ZONE_OFFSET_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss.SSSZ".length() + 2 || length == "yyyy-MM-dd'T'HH:mm:ss.SSSZ".length() + 3) {
                return DateUtils.parse((CharSequence)utcString, DatePattern.UTC_MS_WITH_ZONE_OFFSET_FORMAT);
            }
        }
        throw new DateException("No format fit for date String [{}] !", utcString);
    }

    public static DateTime parseCST(CharSequence cstString) {
        if (cstString == null) {
            return null;
        }
        return DateUtils.parse(cstString, DatePattern.JDK_DATETIME_FORMAT);
    }

    public static DateTime parse(CharSequence dateCharSequence) {
        if (StringUtils.isBlank(dateCharSequence)) {
            return null;
        }
        String dateStr = dateCharSequence.toString();
        dateStr = StringUtils.removeAll((CharSequence)dateStr.trim(), '\u65e5', '\u79d2');
        int length = dateStr.length();
        if (NumberUtils.isNumber(dateStr)) {
            if (length == "yyyyMMddHHmmss".length()) {
                return DateUtils.parse((CharSequence)dateStr, DatePattern.PURE_DATETIME_FORMAT);
            }
            if (length == "yyyyMMddHHmmssSSS".length()) {
                return DateUtils.parse((CharSequence)dateStr, DatePattern.PURE_DATETIME_MS_FORMAT);
            }
            if (length == "yyyyMMdd".length()) {
                return DateUtils.parse((CharSequence)dateStr, DatePattern.PURE_DATE_FORMAT);
            }
            if (length == "HHmmss".length()) {
                return DateUtils.parse((CharSequence)dateStr, DatePattern.PURE_TIME_FORMAT);
            }
        } else {
            if (RegexUtils.isMatch(PatternPool.TIME, (CharSequence)dateStr)) {
                return DateUtils.parseTimeToday(dateStr);
            }
            if (StringUtils.containsAnyIgnoreCase(dateStr, wtb)) {
                return DateUtils.parseCST(dateStr);
            }
            if (StringUtils.contains((CharSequence)dateStr, 'T')) {
                return DateUtils.parseUTC(dateStr);
            }
        }
        dateStr = DateUtils.normalize(dateStr);
        Matcher matcher = DatePattern.REGEX_NORM.matcher(dateStr);
        if (RegexUtils.isMatch(DatePattern.REGEX_NORM, (CharSequence)dateStr)) {
            int colonCount = StringUtils.count((CharSequence)dateStr, ':');
            switch (colonCount) {
                case 0: {
                    return DateUtils.parse((CharSequence)dateStr, DatePattern.NORM_DATE_FORMAT);
                }
                case 1: {
                    return DateUtils.parse((CharSequence)dateStr, DatePattern.NORM_DATETIME_MINUTE_FORMAT);
                }
                case 2: {
                    if (StringUtils.contains((CharSequence)dateStr, '.')) {
                        return DateUtils.parse((CharSequence)dateStr, DatePattern.NORM_DATETIME_MS_FORMAT);
                    }
                    return DateUtils.parse((CharSequence)dateStr, DatePattern.NORM_DATETIME_FORMAT);
                }
            }
        }
        throw new DateException("No format fit for date String [{}] !", dateStr);
    }

    public static DateTime truncate(Date date, DateFieldEnum dateField) {
        return new DateTime(DateUtils.truncate(DateUtils.calendar(date), dateField));
    }

    public static DateTime round(Date date, DateFieldEnum dateField) {
        return new DateTime(DateUtils.round(DateUtils.calendar(date), dateField));
    }

    public static DateTime ceiling(Date date, DateFieldEnum dateField) {
        return new DateTime(DateUtils.ceiling(DateUtils.calendar(date), dateField));
    }

    public static DateTime beginOfSecond(Date date) {
        return new DateTime(DateUtils.beginOfSecond(DateUtils.calendar(date)));
    }

    public static DateTime endOfSecond(Date date) {
        return new DateTime(DateUtils.endOfSecond(DateUtils.calendar(date)));
    }

    public static DateTime beginOfDay(Date date) {
        return new DateTime(DateUtils.beginOfDay(DateUtils.calendar(date)));
    }

    public static DateTime endOfDay(Date date) {
        return new DateTime(DateUtils.endOfDay(DateUtils.calendar(date)));
    }

    public static DateTime beginOfWeek(Date date) {
        return new DateTime(DateUtils.beginOfWeek(DateUtils.calendar(date)));
    }

    public static DateTime endOfWeek(Date date) {
        return new DateTime(DateUtils.endOfWeek(DateUtils.calendar(date)));
    }

    public static DateTime beginOfMonth(Date date) {
        return new DateTime(DateUtils.beginOfMonth(DateUtils.calendar(date)));
    }

    public static DateTime endOfMonth(Date date) {
        return new DateTime(DateUtils.endOfMonth(DateUtils.calendar(date)));
    }

    public static DateTime beginOfQuarter(Date date) {
        return new DateTime(DateUtils.beginOfQuarter(DateUtils.calendar(date)));
    }

    public static DateTime endOfQuarter(Date date) {
        return new DateTime(DateUtils.endOfQuarter(DateUtils.calendar(date)));
    }

    public static DateTime beginOfYear(Date date) {
        return new DateTime(DateUtils.beginOfYear(DateUtils.calendar(date)));
    }

    public static DateTime endOfYear(Date date) {
        return new DateTime(DateUtils.endOfYear(DateUtils.calendar(date)));
    }

    public static DateTime yesterday() {
        return DateUtils.offsetDay(new DateTime(), -1);
    }

    public static DateTime tomorrow() {
        return DateUtils.offsetDay(new DateTime(), 1);
    }

    public static DateTime lastWeek() {
        return DateUtils.offsetWeek(new DateTime(), -1);
    }

    public static DateTime nextWeek() {
        return DateUtils.offsetWeek(new DateTime(), 1);
    }

    public static DateTime lastMonth() {
        return DateUtils.offsetMonth(new DateTime(), -1);
    }

    public static DateTime nextMonth() {
        return DateUtils.offsetMonth(new DateTime(), 1);
    }

    public static DateTime offsetMillisecond(Date date, int offset) {
        return DateUtils.offset(date, DateFieldEnum.MILLISECOND, offset);
    }

    public static DateTime offsetSecond(Date date, int offset) {
        return DateUtils.offset(date, DateFieldEnum.SECOND, offset);
    }

    public static DateTime offsetMinute(Date date, int offset) {
        return DateUtils.offset(date, DateFieldEnum.MINUTE, offset);
    }

    public static DateTime offsetHour(Date date, int offset) {
        return DateUtils.offset(date, DateFieldEnum.HOUR_OF_DAY, offset);
    }

    public static DateTime offsetDay(Date date, int offset) {
        return DateUtils.offset(date, DateFieldEnum.DAY_OF_YEAR, offset);
    }

    public static DateTime offsetWeek(Date date, int offset) {
        return DateUtils.offset(date, DateFieldEnum.WEEK_OF_YEAR, offset);
    }

    public static DateTime offsetMonth(Date date, int offset) {
        return DateUtils.offset(date, DateFieldEnum.MONTH, offset);
    }

    public static DateTime offset(Date date, DateFieldEnum dateField, int offset) {
        return DateUtils.dateNew(date).offset(dateField, offset);
    }

    @Deprecated
    public static DateTime offsetDate(Date date, DateFieldEnum dateField, int offset) {
        return DateUtils.offset(date, dateField, offset);
    }

    public static long between(Date beginDate, Date endDate, DateUnitEnum unit) {
        return DateUtils.between(beginDate, endDate, unit, true);
    }

    public static long between(Date beginDate, Date endDate, DateUnitEnum unit, boolean isAbs) {
        return new DateBetween(beginDate, endDate, isAbs).between(unit);
    }

    public static long betweenMs(Date beginDate, Date endDate) {
        return new DateBetween(beginDate, endDate).between(DateUnitEnum.MS);
    }

    public static long betweenDay(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateUtils.beginOfDay(beginDate);
            endDate = DateUtils.beginOfDay(endDate);
        }
        return DateUtils.between(beginDate, endDate, DateUnitEnum.DAY);
    }

    public static long betweenWeek(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateUtils.beginOfDay(beginDate);
            endDate = DateUtils.beginOfDay(endDate);
        }
        return DateUtils.between(beginDate, endDate, DateUnitEnum.WEEK);
    }

    public static long betweenMonth(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenMonth(isReset);
    }

    public static long betweenYear(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenYear(isReset);
    }

    public static String formatBetween(Date beginDate, Date endDate, BetweenFormat.Level level) {
        return DateUtils.formatBetween(DateUtils.between(beginDate, endDate, DateUnitEnum.MS), level);
    }

    public static String formatBetween(Date beginDate, Date endDate) {
        return DateUtils.formatBetween(DateUtils.between(beginDate, endDate, DateUnitEnum.MS));
    }

    public static String formatBetween(long betweenMs, BetweenFormat.Level level) {
        return new BetweenFormat(betweenMs, level).format();
    }

    public static String formatBetween(long betweenMs) {
        return new BetweenFormat(betweenMs, BetweenFormat.Level.MILLSECOND).format();
    }

    public static boolean isIn(Date date, Date beginDate, Date endDate) {
        if (date instanceof DateTime) {
            return ((DateTime)date).isIn(beginDate, endDate);
        }
        return new DateTime(date).isIn(beginDate, endDate);
    }

    public static boolean isSameTime(Date date1, Date date2) {
        return date1.compareTo(date2) == 0;
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return DateUtils.isSameDay(DateUtils.calendar(date1), DateUtils.calendar(date2));
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static int toIntSecond(Date date) {
        return Integer.parseInt(DateUtils.format(date, "yyMMddHHmm"));
    }

    @Deprecated
    public static int weekCount(Date start, Date end) {
        return (int)DateUtils.betweenWeek(start, end, true);
    }

    public static TimeInterval timer() {
        return new TimeInterval();
    }

    public static TimeInterval timer(boolean isNano) {
        return new TimeInterval(isNano);
    }

    public static StopWatch createStopWatch() {
        return new StopWatch();
    }

    public static StopWatch createStopWatch(String id) {
        return new StopWatch(id);
    }

    public static int ageOfNow(String birthDay) {
        return DateUtils.ageOfNow(DateUtils.parse(birthDay));
    }

    public static int ageOfNow(Date birthDay) {
        return DateUtils.age(birthDay, DateUtils.date());
    }

    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    public static int age(Date birthday, Date dateToCompare) {
        Assert.notNull(birthday, "Birthday can not be null !", new Object[0]);
        if (null == dateToCompare) {
            dateToCompare = DateUtils.date();
        }
        return DateUtils.age(birthday.getTime(), dateToCompare.getTime());
    }

    @Deprecated
    public static boolean isExpired(Date startDate, DateFieldEnum dateField, int timeLength, Date endDate) {
        DateTime offsetDate = DateUtils.offset(startDate, dateField, timeLength);
        return offsetDate.after(endDate);
    }

    @Deprecated
    public static boolean isExpired(Date startDate, Date endDate, Date checkDate) {
        return DateUtils.betweenMs(startDate, checkDate) > DateUtils.betweenMs(startDate, endDate);
    }

    public static int timeToSecond(String timeStr) {
        if (StringUtils.isEmpty(timeStr)) {
            return 0;
        }
        List<String> hms = StringUtils.splitTrim((CharSequence)timeStr, ':', 3);
        int lastIndex = hms.size() - 1;
        int result = 0;
        for (int i = lastIndex; i >= 0; --i) {
            result = (int)((double)result + (double)Integer.parseInt(hms.get(i)) * Math.pow(60.0, lastIndex - i));
        }
        return result;
    }

    public static String secondToTime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Seconds must be a positive number!");
        }
        int hour = seconds / 3600;
        int other = seconds % 3600;
        int minute = other / 60;
        int second = other % 60;
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(":");
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        return sb.toString();
    }

    public static DateRange range(Date start, Date end, DateFieldEnum unit) {
        return new DateRange(start, end, unit);
    }

    public static List<DateTime> rangeToList(Date start, Date end, DateFieldEnum unit) {
        return CollectionUtils.newArrayList(DateUtils.range(start, end, unit));
    }

    public static String getZodiac(int month, int day) {
        return Zodiac.getZodiac(month, day);
    }

    public static String getChineseZodiac(int year) {
        return Zodiac.getChineseZodiac(year);
    }

    public static int compare(Date date1, Date date2) {
        return CompareUtils.compare(date1, date2);
    }

    public static long nanosToMillis(long duration) {
        return TimeUnit.NANOSECONDS.toMillis(duration);
    }

    public static double nanosToSeconds(long duration) {
        return (double)duration / 1.0E9;
    }

    public static Instant toInstant(Date date) {
        return null == date ? null : date.toInstant();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        Instant result = temporalAccessor instanceof Instant ? (Instant)temporalAccessor : (temporalAccessor instanceof LocalDateTime ? ((LocalDateTime)temporalAccessor).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof ZonedDateTime ? ((ZonedDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof OffsetDateTime ? ((OffsetDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof LocalDate ? ((LocalDate)temporalAccessor).atStartOfDay(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof LocalTime ? ((LocalTime)temporalAccessor).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof OffsetTime ? ((OffsetTime)temporalAccessor).atDate(LocalDate.now()).toInstant() : Instant.from(temporalAccessor)))))));
        return result;
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        DateTime dateTime = DateUtils.date(date);
        return LocalDateTime.ofInstant(dateTime.toInstant(), dateTime.getZoneId());
    }

    public static int lengthOfYear(int year) {
        return Year.of(year).length();
    }

    private static String normalize(CharSequence dateStr) {
        if (StringUtils.isBlank(dateStr)) {
            return StringUtils.str(dateStr);
        }
        List<String> dateAndTime = StringUtils.splitTrim(dateStr, ' ');
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return StringUtils.str(dateStr);
        }
        StringBuilder builder = StringUtils.builder();
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = StringUtils.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = StringUtils.removeSuffix(timePart, ":");
            timePart = timePart.replace(',', '.');
            builder.append(timePart);
        }
        return builder.toString();
    }
}

