/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.date;

import com.github.jarvisframework.tool.core.date.DateUnitEnum;
import com.github.jarvisframework.tool.core.date.DateUtils;
import java.io.Serializable;

public class TimeInterval
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long time;
    private final boolean isNano;

    public TimeInterval() {
        this(false);
    }

    public TimeInterval(boolean isNano) {
        this.isNano = isNano;
        this.start();
    }

    public long start() {
        this.time = DateUtils.current(this.isNano);
        return this.time;
    }

    public long intervalRestart() {
        long now = DateUtils.current(this.isNano);
        long d = now - this.time;
        this.time = now;
        return d;
    }

    public TimeInterval restart() {
        this.time = DateUtils.current(this.isNano);
        return this;
    }

    public long interval() {
        return DateUtils.current(this.isNano) - this.time;
    }

    public String intervalPretty() {
        return DateUtils.formatBetween(this.intervalMs());
    }

    public long intervalMs() {
        return this.isNano ? this.interval() / 1000000L : this.interval();
    }

    public long intervalSecond() {
        return this.intervalMs() / DateUnitEnum.SECOND.getMillis();
    }

    public long intervalMinute() {
        return this.intervalMs() / DateUnitEnum.MINUTE.getMillis();
    }

    public long intervalHour() {
        return this.intervalMs() / DateUnitEnum.HOUR.getMillis();
    }

    public long intervalDay() {
        return this.intervalMs() / DateUnitEnum.DAY.getMillis();
    }

    public long intervalWeek() {
        return this.intervalMs() / DateUnitEnum.WEEK.getMillis();
    }
}

