/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.io.file;

import com.github.jarvisframework.tool.core.date.DateUnitEnum;
import com.github.jarvisframework.tool.core.exception.UtilException;
import com.github.jarvisframework.tool.core.io.FileUtils;
import com.github.jarvisframework.tool.core.io.IORuntimeException;
import com.github.jarvisframework.tool.core.io.LineHandler;
import com.github.jarvisframework.tool.core.io.file.FileModeEnum;
import com.github.jarvisframework.tool.core.io.file.LineReadWatcher;
import com.github.jarvisframework.tool.core.lang.Console;
import com.github.jarvisframework.tool.core.util.CharsetUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Tailer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final LineHandler CONSOLE_HANDLER = new ConsoleLineHandler();
    private final Charset charset;
    private final LineHandler lineHandler;
    private final int initReadLine;
    private final long period;
    private final RandomAccessFile randomAccessFile;
    private final ScheduledExecutorService executorService;

    public Tailer(File file, LineHandler lineHandler) {
        this(file, lineHandler, 0);
    }

    public Tailer(File file, LineHandler lineHandler, int initReadLine) {
        this(file, CharsetUtils.CHARSET_UTF_8, lineHandler, initReadLine, DateUnitEnum.SECOND.getMillis());
    }

    public Tailer(File file, Charset charset, LineHandler lineHandler) {
        this(file, charset, lineHandler, 0, DateUnitEnum.SECOND.getMillis());
    }

    public Tailer(File file, Charset charset, LineHandler lineHandler, int initReadLine, long period) {
        Tailer.checkFile(file);
        this.charset = charset;
        this.lineHandler = lineHandler;
        this.period = period;
        this.initReadLine = initReadLine;
        this.randomAccessFile = FileUtils.createRandomAccessFile(file, FileModeEnum.r);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean async) {
        try {
            this.readTail();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        LineReadWatcher lineReadWatcher = new LineReadWatcher(this.randomAccessFile, this.charset, this.lineHandler);
        ScheduledFuture<?> scheduledFuture = this.executorService.scheduleAtFixedRate(lineReadWatcher, 0L, this.period, TimeUnit.MILLISECONDS);
        if (!async) {
            try {
                scheduledFuture.get();
            }
            catch (ExecutionException e) {
                throw new UtilException(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void readTail() throws IOException {
        long len = this.randomAccessFile.length();
        if (this.initReadLine > 0) {
            Stack<String> stack = new Stack<String>();
            long start = this.randomAccessFile.getFilePointer();
            long nextEnd = len - 1L;
            this.randomAccessFile.seek(nextEnd);
            int currentLine = 0;
            while (nextEnd > start && currentLine <= this.initReadLine) {
                String line;
                int c = this.randomAccessFile.read();
                if (c == 10 || c == 13) {
                    line = FileUtils.readLine(this.randomAccessFile, this.charset);
                    if (null != line) {
                        stack.push(line);
                    }
                    ++currentLine;
                    --nextEnd;
                }
                this.randomAccessFile.seek(--nextEnd);
                if (nextEnd != 0L) continue;
                line = FileUtils.readLine(this.randomAccessFile, this.charset);
                if (null == line) break;
                stack.push(line);
                break;
            }
            while (!stack.isEmpty()) {
                this.lineHandler.handle((String)stack.pop());
            }
        }
        try {
            this.randomAccessFile.seek(len);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static void checkFile(File file) {
        if (!file.exists()) {
            throw new UtilException("File [{}] not exist !", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new UtilException("Path [{}] is not a file !", file.getAbsolutePath());
        }
    }

    public static class ConsoleLineHandler
    implements LineHandler {
        @Override
        public void handle(String line) {
            Console.log(line);
        }
    }
}

