/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.io.resource;

import com.github.jarvisframework.tool.core.io.IORuntimeException;
import com.github.jarvisframework.tool.core.io.IOUtils;
import com.github.jarvisframework.tool.core.util.CharsetUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;

public interface Resource {
    public String getName();

    public URL getUrl();

    public InputStream getStream();

    default public void writeTo(OutputStream out) throws IORuntimeException {
        try (InputStream in = this.getStream();){
            IOUtils.copy(in, out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public BufferedReader getReader(Charset var1);

    public String readStr(Charset var1) throws IORuntimeException;

    default public String readUtf8Str() throws IORuntimeException {
        return this.readStr(CharsetUtils.CHARSET_UTF_8);
    }

    public byte[] readBytes() throws IORuntimeException;
}

