/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.lang;

import com.github.jarvisframework.tool.core.collection.CollectionUtils;
import com.github.jarvisframework.tool.core.collection.EnumerationIter;
import com.github.jarvisframework.tool.core.io.IORuntimeException;
import com.github.jarvisframework.tool.core.lang.Filter;
import com.github.jarvisframework.tool.core.util.CharsetUtils;
import com.github.jarvisframework.tool.core.util.ClassLoaderUtils;
import com.github.jarvisframework.tool.core.util.ClassUtils;
import com.github.jarvisframework.tool.core.util.ResourceUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.core.util.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassScanner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String packageName;
    private final String packageNameWithDot;
    private final String packageDirName;
    private final String packagePath;
    private final Filter<Class<?>> classFilter;
    private final Charset charset;
    private ClassLoader classLoader;
    private boolean initialize;
    private final Set<Class<?>> classes = new HashSet();

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScanner.scanPackage(packageName, clazz -> clazz.isAnnotationPresent(annotationClass));
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScanner.scanPackage(packageName, clazz -> superClass.isAssignableFrom((Class<?>)clazz) && !superClass.equals(clazz));
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScanner.scanPackage("", null);
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScanner.scanPackage(packageName, null);
    }

    public static Set<Class<?>> scanPackage(String packageName, Filter<Class<?>> classFilter) {
        return new ClassScanner(packageName, classFilter).scan();
    }

    public ClassScanner() {
        this(null);
    }

    public ClassScanner(String packageName) {
        this(packageName, null);
    }

    public ClassScanner(String packageName, Filter<Class<?>> classFilter) {
        this(packageName, classFilter, CharsetUtils.CHARSET_UTF_8);
    }

    public ClassScanner(String packageName, Filter<Class<?>> classFilter, Charset charset) {
        this.packageName = packageName = StringUtils.nullToEmpty(packageName);
        this.packageNameWithDot = StringUtils.addSuffixIfNot(packageName, ".");
        this.packageDirName = packageName.replace('.', File.separatorChar);
        this.packagePath = packageName.replace('.', '/');
        this.classFilter = classFilter;
        this.charset = charset;
    }

    public Set<Class<?>> scan() {
        for (URL url : ResourceUtils.getResourceIter(this.packagePath)) {
            switch (url.getProtocol()) {
                case "file": {
                    this.scanFile(new File(UrlUtils.decode(url.getFile(), this.charset.name())), null);
                    break;
                }
                case "jar": {
                    this.scanJar(UrlUtils.getJarFile(url));
                }
            }
        }
        if (CollectionUtils.isEmpty(this.classes)) {
            this.scanJavaClassPaths();
        }
        return Collections.unmodifiableSet(this.classes);
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private void scanJavaClassPaths() {
        String[] javaClassPaths;
        for (String classPath : javaClassPaths = ClassUtils.getJavaClassPaths()) {
            classPath = UrlUtils.decode(classPath, CharsetUtils.systemCharsetName());
            this.scanFile(new File(classPath), null);
        }
    }

    private void scanFile(File file, String rootDir) {
        File[] files;
        if (file.isFile()) {
            String fileName = file.getAbsolutePath();
            if (fileName.endsWith(".class")) {
                String className = fileName.substring(rootDir.length(), fileName.length() - 6).replace(File.separatorChar, '.');
                this.addIfAccept(className);
            } else if (fileName.endsWith(".jar")) {
                try {
                    this.scanJar(new JarFile(file));
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
        } else if (file.isDirectory() && null != (files = file.listFiles())) {
            for (File subFile : files) {
                this.scanFile(subFile, null == rootDir ? this.subPathBeforePackage(file) : rootDir);
            }
        }
    }

    private void scanJar(JarFile jar) {
        for (JarEntry entry : new EnumerationIter<JarEntry>(jar.entries())) {
            String name = StringUtils.removePrefix(entry.getName(), "/");
            if (!name.startsWith(this.packagePath) || !name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(0, name.length() - 6).replace('/', '.');
            this.addIfAccept(this.loadClass(className));
        }
    }

    private Class<?> loadClass(String className) {
        ClassLoader loader = this.classLoader;
        if (null == loader) {
            this.classLoader = loader = ClassLoaderUtils.getClassLoader();
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, this.initialize, loader);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clazz;
    }

    private void addIfAccept(String className) {
        int packageLen;
        if (StringUtils.isBlank(className)) {
            return;
        }
        int classLen = className.length();
        if (classLen == (packageLen = this.packageName.length())) {
            if (className.equals(this.packageName)) {
                this.addIfAccept(this.loadClass(className));
            }
        } else if (classLen > packageLen && className.startsWith(this.packageNameWithDot)) {
            this.addIfAccept(this.loadClass(className));
        }
    }

    private void addIfAccept(Class<?> clazz) {
        Filter<Class<?>> classFilter;
        if (null != clazz && ((classFilter = this.classFilter) == null || classFilter.accept(clazz))) {
            this.classes.add(clazz);
        }
    }

    private String subPathBeforePackage(File file) {
        String filePath = file.getAbsolutePath();
        if (StringUtils.isNotEmpty(this.packageDirName)) {
            filePath = StringUtils.subBefore((CharSequence)filePath, this.packageDirName, true);
        }
        return StringUtils.addSuffixIfNot(filePath, File.separator);
    }
}

