/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.lang;

import com.github.jarvisframework.tool.core.lang.Assert;
import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.util.Scanner;

public class Console {
    private static final String TEMPLATE_VAR = "{}";

    public static void log() {
        System.out.println();
    }

    public static void log(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.log(e, e.getMessage(), new Object[0]);
        } else {
            Console.log(TEMPLATE_VAR, obj);
        }
    }

    public static void log(Object obj1, Object ... otherObjs) {
        if (ArrayUtils.isEmpty(otherObjs)) {
            Console.log(obj1);
        } else {
            Console.log(Console.buildTemplateSplitBySpace(otherObjs.length + 1), ArrayUtils.insert(otherObjs, 0, obj1));
        }
    }

    public static void log(String template, Object ... values) {
        if (ArrayUtils.isEmpty(values) || StringUtils.contains((CharSequence)template, TEMPLATE_VAR)) {
            Console.logInternal(template, values);
        } else {
            Console.logInternal(Console.buildTemplateSplitBySpace(values.length + 1), ArrayUtils.insert(values, 0, new Object[]{template}));
        }
    }

    public static void log(Throwable t, String template, Object ... values) {
        System.out.println(StringUtils.format((CharSequence)template, values));
        if (null != t) {
            t.printStackTrace();
            System.out.flush();
        }
    }

    private static void logInternal(String template, Object ... values) {
        Console.log(null, template, values);
    }

    public static void print(Object obj) {
        Console.print(TEMPLATE_VAR, obj);
    }

    public static void print(Object obj1, Object ... otherObjs) {
        if (ArrayUtils.isEmpty(otherObjs)) {
            Console.print(obj1);
        } else {
            Console.print(Console.buildTemplateSplitBySpace(otherObjs.length + 1), ArrayUtils.insert(otherObjs, 0, obj1));
        }
    }

    public static void print(String template, Object ... values) {
        if (ArrayUtils.isEmpty(values) || StringUtils.contains((CharSequence)template, TEMPLATE_VAR)) {
            Console.printInternal(template, values);
        } else {
            Console.printInternal(Console.buildTemplateSplitBySpace(values.length + 1), ArrayUtils.insert(values, 0, new Object[]{template}));
        }
    }

    public static void printProgress(char showChar, int len) {
        Console.print("{}{}", Character.valueOf('\r'), StringUtils.repeat(showChar, len));
    }

    public static void printProgress(char showChar, int totalLen, double rate) {
        Assert.isTrue(rate >= 0.0 && rate <= 1.0, "Rate must between 0 and 1 (both include)", new Object[0]);
        Console.printProgress(showChar, (int)((double)totalLen * rate));
    }

    private static void printInternal(String template, Object ... values) {
        System.out.print(StringUtils.format((CharSequence)template, values));
    }

    public static void error() {
        System.err.println();
    }

    public static void error(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.error(e, e.getMessage(), new Object[0]);
        } else {
            Console.error(TEMPLATE_VAR, obj);
        }
    }

    public static void error(Object obj1, Object ... otherObjs) {
        if (ArrayUtils.isEmpty(otherObjs)) {
            Console.error(obj1);
        } else {
            Console.error(Console.buildTemplateSplitBySpace(otherObjs.length + 1), ArrayUtils.insert(otherObjs, 0, obj1));
        }
    }

    public static void error(String template, Object ... values) {
        if (ArrayUtils.isEmpty(values) || StringUtils.contains((CharSequence)template, TEMPLATE_VAR)) {
            Console.errorInternal(template, values);
        } else {
            Console.errorInternal(Console.buildTemplateSplitBySpace(values.length + 1), ArrayUtils.insert(values, 0, new Object[]{template}));
        }
    }

    public static void error(Throwable t, String template, Object ... values) {
        System.err.println(StringUtils.format((CharSequence)template, values));
        if (null != t) {
            t.printStackTrace(System.err);
            System.err.flush();
        }
    }

    private static void errorInternal(String template, Object ... values) {
        Console.error(null, template, values);
    }

    public static Scanner scanner() {
        return new Scanner(System.in);
    }

    public static String input() {
        return Console.scanner().next();
    }

    public static String where() {
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[1];
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        String fileName = stackTraceElement.getFileName();
        Integer lineNumber = stackTraceElement.getLineNumber();
        return String.format("%s.%s(%s:%s)", className, methodName, fileName, lineNumber);
    }

    public static Integer lineNumber() {
        return new Throwable().getStackTrace()[1].getLineNumber();
    }

    private static String buildTemplateSplitBySpace(int count) {
        return StringUtils.repeatAndJoin(TEMPLATE_VAR, count, " ");
    }
}

