/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.lang;

import com.github.jarvisframework.tool.core.bean.BeanUtils;
import com.github.jarvisframework.tool.core.collection.CollectionUtils;
import com.github.jarvisframework.tool.core.convert.Convert;
import com.github.jarvisframework.tool.core.getter.BasicTypeGetter;
import com.github.jarvisframework.tool.core.lang.Assert;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class Dictionary
extends LinkedHashMap<String, Object>
implements BasicTypeGetter<String> {
    private static final long serialVersionUID = 6135423866861206530L;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    private boolean caseInsensitive;

    public static Dictionary create() {
        return new Dictionary();
    }

    public static <T> Dictionary parse(T bean) {
        return Dictionary.create().parseBean(bean);
    }

    public Dictionary() {
        this(false);
    }

    public Dictionary(boolean caseInsensitive) {
        this(16, caseInsensitive);
    }

    public Dictionary(int initialCapacity) {
        this(initialCapacity, false);
    }

    public Dictionary(int initialCapacity, boolean caseInsensitive) {
        this(initialCapacity, 0.75f, caseInsensitive);
    }

    public Dictionary(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, false);
    }

    public Dictionary(int initialCapacity, float loadFactor, boolean caseInsensitive) {
        super(initialCapacity, loadFactor);
        this.caseInsensitive = caseInsensitive;
    }

    public Dictionary(Map<String, Object> m) {
        super(null == m ? new HashMap() : m);
    }

    public <T> T toBean(T bean) {
        return this.toBean(bean, false);
    }

    public <T> T toBeanIgnoreCase(T bean) {
        BeanUtils.fillBeanWithMapIgnoreCase(this, bean, false);
        return bean;
    }

    public <T> T toBean(T bean, boolean isToCamelCase) {
        BeanUtils.fillBeanWithMap(this, bean, isToCamelCase, false);
        return bean;
    }

    public <T> T toBeanWithCamelCase(T bean) {
        BeanUtils.fillBeanWithMap(this, bean, true, false);
        return bean;
    }

    public <T> T toBean(Class<T> clazz) {
        return BeanUtils.mapToBean(this, clazz, false);
    }

    public <T> T toBeanIgnoreCase(Class<T> clazz) {
        return BeanUtils.mapToBeanIgnoreCase(this, clazz, false);
    }

    public <T> Dictionary parseBean(T bean) {
        Assert.notNull(bean, "Bean class must be not null", new Object[0]);
        this.putAll((Map<? extends String, ?>)BeanUtils.beanToMap(bean));
        return this;
    }

    public <T> Dictionary parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        Assert.notNull(bean, "Bean class must be not null", new Object[0]);
        this.putAll((Map<? extends String, ?>)BeanUtils.beanToMap(bean, isToUnderlineCase, ignoreNullValue));
        return this;
    }

    public <T extends Dictionary> void removeEqual(T dict, String ... withoutNames) {
        HashSet<String> withoutSet = CollectionUtils.newHashSet(withoutNames);
        for (Map.Entry entry : dict.entrySet()) {
            Object value;
            if (withoutSet.contains(entry.getKey()) || null == (value = this.get(entry.getKey())) || !value.equals(entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public Dictionary filter(String ... keys) {
        Dictionary result = new Dictionary(keys.length, 1.0f);
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return result;
    }

    public Dictionary set(String attr, Object value) {
        this.put(attr, value);
        return this;
    }

    public Dictionary setIgnoreNull(String attr, Object value) {
        if (null != attr && null != value) {
            this.set(attr, value);
        }
        return this;
    }

    @Override
    public Object getObject(String key) {
        return super.get(key);
    }

    public <T> T getBean(String attr) {
        return this.get(attr, null);
    }

    public <T> T get(String attr, T defaultValue) {
        Object result = this.get(attr);
        return (T)(result != null ? result : defaultValue);
    }

    @Override
    public String getString(String attr) {
        return Convert.toString(this.get(attr), null);
    }

    @Override
    public Integer getInt(String attr) {
        return Convert.toInt(this.get(attr), null);
    }

    @Override
    public Long getLong(String attr) {
        return Convert.toLong(this.get(attr), null);
    }

    @Override
    public Float getFloat(String attr) {
        return Convert.toFloat(this.get(attr), null);
    }

    @Override
    public Short getShort(String attr) {
        return Convert.toShort(this.get(attr), null);
    }

    @Override
    public Character getChar(String attr) {
        return Convert.toChar(this.get(attr), null);
    }

    @Override
    public Double getDouble(String attr) {
        return Convert.toDouble(this.get(attr), null);
    }

    @Override
    public Byte getByte(String attr) {
        return Convert.toByte(this.get(attr), null);
    }

    @Override
    public Boolean getBoolean(String attr) {
        return Convert.toBoolean(this.get(attr), null);
    }

    @Override
    public BigDecimal getBigDecimal(String attr) {
        return Convert.toBigDecimal(this.get(attr));
    }

    @Override
    public BigInteger getBigInteger(String attr) {
        return Convert.toBigInteger(this.get(attr));
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        return Convert.toEnum(clazz, this.get(key));
    }

    public byte[] getBytes(String attr) {
        return this.get(attr, null);
    }

    @Override
    public Date getDate(String attr) {
        return this.get(attr, null);
    }

    public Time getTime(String attr) {
        return this.get(attr, null);
    }

    public Timestamp getTimestamp(String attr) {
        return this.get(attr, null);
    }

    public Number getNumber(String attr) {
        return this.get(attr, null);
    }

    @Override
    public Object get(Object key) {
        return super.get(this.customKey((String)key));
    }

    @Override
    public Object put(String key, Object value) {
        return super.put(this.customKey(key), value);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        m.forEach(this::put);
    }

    @Override
    public Dictionary clone() {
        return (Dictionary)super.clone();
    }

    private String customKey(String key) {
        if (this.caseInsensitive && null != key) {
            key = key.toLowerCase();
        }
        return key;
    }
}

