/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.lang;

import com.github.jarvisframework.tool.core.func.Func0;
import com.github.jarvisframework.tool.core.lang.Assert;
import com.github.jarvisframework.tool.core.lang.SimpleCache;
import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.ClassUtils;
import com.github.jarvisframework.tool.core.util.ReflectUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.util.HashMap;

public final class Singleton {
    private static final SimpleCache<String, Object> POOL = new SimpleCache(new HashMap());

    private Singleton() {
    }

    public static <T> T get(Class<T> clazz, Object ... params) {
        Assert.notNull(clazz, "Class must be not null !", new Object[0]);
        String key = Singleton.buildKey(clazz.getName(), params);
        return (T)Singleton.get(key, () -> ReflectUtils.newInstance(clazz, params));
    }

    public static <T> T get(String key, Func0<T> supplier) {
        return (T)POOL.get(key, supplier::call);
    }

    public static <T> T get(String className, Object ... params) {
        Assert.notBlank(className, "Class name must be not blank !", new Object[0]);
        Class clazz = ClassUtils.loadClass(className);
        return Singleton.get(clazz, params);
    }

    public static void put(Object obj) {
        Assert.notNull(obj, "Bean object must be not null !", new Object[0]);
        Singleton.put(obj.getClass().getName(), obj);
    }

    public static void put(String key, Object obj) {
        POOL.put(key, obj);
    }

    public static void remove(Class<?> clazz) {
        if (null != clazz) {
            Singleton.remove(clazz.getName());
        }
    }

    public static void remove(String key) {
        POOL.remove(key);
    }

    public static void destroy() {
        POOL.clear();
    }

    private static String buildKey(String className, Object ... params) {
        if (ArrayUtils.isEmpty(params)) {
            return className;
        }
        return StringUtils.format((CharSequence)"{}#{}", className, ArrayUtils.join(params, (CharSequence)"_"));
    }
}

