/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.lang;

import com.github.jarvisframework.tool.core.collection.CollectionUtils;
import com.github.jarvisframework.tool.core.map.MapUtils;
import com.github.jarvisframework.tool.core.util.RandomUtils;
import java.io.Serializable;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public class WeightRandom<T>
implements Serializable {
    private static final long serialVersionUID = -8244697995702786499L;
    private final TreeMap<Double, T> weightMap = new TreeMap();
    private final Random random = RandomUtils.getRandom();

    public static <T> WeightRandom<T> create() {
        return new WeightRandom<T>();
    }

    public WeightRandom() {
    }

    public WeightRandom(WeightObj<T> weightObj) {
        this();
        if (null != weightObj) {
            this.add(weightObj);
        }
    }

    public WeightRandom(Iterable<WeightObj<T>> weightObjs) {
        this();
        if (CollectionUtils.isNotEmpty(weightObjs)) {
            for (WeightObj<T> weightObj : weightObjs) {
                this.add(weightObj);
            }
        }
    }

    public WeightRandom(WeightObj<T>[] weightObjs) {
        this();
        for (WeightObj<T> weightObj : weightObjs) {
            this.add(weightObj);
        }
    }

    public WeightRandom<T> add(T obj, double weight) {
        return this.add(new WeightObj<T>(obj, weight));
    }

    public WeightRandom<T> add(WeightObj<T> weightObj) {
        if (null != weightObj) {
            double weight = weightObj.getWeight();
            if (weightObj.getWeight() > 0.0) {
                double lastWeight = this.weightMap.size() == 0 ? 0.0 : this.weightMap.lastKey();
                this.weightMap.put(weight + lastWeight, weightObj.getObj());
            }
        }
        return this;
    }

    public WeightRandom<T> clear() {
        if (null != this.weightMap) {
            this.weightMap.clear();
        }
        return this;
    }

    public T next() {
        if (MapUtils.isEmpty(this.weightMap)) {
            return null;
        }
        double randomWeight = this.weightMap.lastKey() * this.random.nextDouble();
        NavigableMap<Double, T> tailMap = this.weightMap.tailMap(randomWeight, false);
        return this.weightMap.get(tailMap.firstKey());
    }

    public static class WeightObj<T> {
        private T obj;
        private final double weight;

        public WeightObj(T obj, double weight) {
            this.obj = obj;
            this.weight = weight;
        }

        public T getObj() {
            return this.obj;
        }

        public void setObj(T obj) {
            this.obj = obj;
        }

        public double getWeight() {
            return this.weight;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.obj == null ? 0 : this.obj.hashCode());
            long temp = Double.doubleToLongBits(this.weight);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WeightObj other = (WeightObj)obj;
            if (this.obj == null ? other.obj != null : !this.obj.equals(other.obj)) {
                return false;
            }
            return Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
        }
    }
}

