/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.lang.caller;

import com.github.jarvisframework.tool.core.lang.caller.Caller;
import com.github.jarvisframework.tool.core.lang.caller.SecurityManagerCaller;
import com.github.jarvisframework.tool.core.lang.caller.StackTraceCaller;
import java.io.Serializable;

public class CallerUtils {
    private static final Caller INSTANCE = CallerUtils.tryCreateCaller();

    public static Class<?> getCaller() {
        return INSTANCE.getCaller();
    }

    public static Class<?> getCallerCaller() {
        return INSTANCE.getCallerCaller();
    }

    public static Class<?> getCaller(int depth) {
        return INSTANCE.getCaller(depth);
    }

    public static boolean isCalledBy(Class<?> clazz) {
        return INSTANCE.isCalledBy(clazz);
    }

    public static String getCallerMethodName(boolean isFullName) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
        String methodName = stackTraceElement.getMethodName();
        if (!isFullName) {
            return methodName;
        }
        return stackTraceElement.getClassName() + "." + methodName;
    }

    private static Caller tryCreateCaller() {
        Serializable caller;
        try {
            caller = new SecurityManagerCaller();
            if (null != caller.getCaller() && null != caller.getCallerCaller()) {
                return caller;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        caller = new StackTraceCaller();
        return caller;
    }
}

