/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.map;

import com.github.jarvisframework.tool.core.map.CustomKeyMap;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class CamelCaseMap<K, V>
extends CustomKeyMap<K, V> {
    private static final long serialVersionUID = 4043263744224569870L;

    public CamelCaseMap() {
        this(16);
    }

    public CamelCaseMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CamelCaseMap(Map<? extends K, ? extends V> m) {
        this(0.75f, m);
    }

    public CamelCaseMap(float loadFactor, Map<? extends K, ? extends V> m) {
        this(m.size(), loadFactor);
        this.putAll(m);
    }

    public CamelCaseMap(int initialCapacity, float loadFactor) {
        super(new HashMap(initialCapacity, loadFactor));
    }

    @Override
    protected Object customKey(Object key) {
        if (key instanceof CharSequence) {
            key = StringUtils.toCamelCase(key.toString());
        }
        return key;
    }
}

