/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.net;

import com.github.jarvisframework.tool.core.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Ipv4Utils {
    public static final String IP_SPLIT_MARK = "-";
    public static final String IP_MASK_SPLIT_MARK = "/";
    public static final int IP_MASK_MAX = 32;

    public static String formatIpBlock(String ip, String mask) {
        return ip + IP_MASK_SPLIT_MARK + Ipv4Utils.getMaskBitByMask(mask);
    }

    public static List<String> list(String ipRange, boolean isAll) {
        if (ipRange.contains(IP_SPLIT_MARK)) {
            String[] range = ipRange.split(IP_SPLIT_MARK);
            return Ipv4Utils.list(range[0], range[1]);
        }
        if (ipRange.contains(IP_MASK_SPLIT_MARK)) {
            String[] param = ipRange.split(IP_MASK_SPLIT_MARK);
            return Ipv4Utils.list(param[0], Integer.parseInt(param[1]), isAll);
        }
        ArrayList<String> ips = new ArrayList<String>();
        ips.add(ipRange);
        return ips;
    }

    public static List<String> list(String ip, int maskBit, boolean isAll) {
        List<String> list = new ArrayList<String>();
        if (maskBit == 32) {
            if (Boolean.TRUE.equals(isAll)) {
                list.add(ip);
            }
        } else {
            String startIp = Ipv4Utils.getBeginIpStr(ip, maskBit);
            String endIp = Ipv4Utils.getEndIpStr(ip, maskBit);
            String subStart = startIp.split("\\.")[0] + "." + startIp.split("\\.")[1] + "." + startIp.split("\\.")[2] + ".";
            String subEnd = endIp.split("\\.")[0] + "." + endIp.split("\\.")[1] + "." + endIp.split("\\.")[2] + ".";
            if (Boolean.TRUE.equals(isAll)) {
                startIp = subStart + Integer.parseInt(startIp.split("\\.")[3]);
                endIp = subEnd + Integer.parseInt(endIp.split("\\.")[3]);
            } else {
                startIp = subStart + (Integer.parseInt(startIp.split("\\.")[3]) + 1);
                endIp = subEnd + (Integer.parseInt(endIp.split("\\.")[3]) - 1);
            }
            list = Ipv4Utils.list(startIp, endIp);
        }
        return list;
    }

    public static List<String> list(String ipFrom, String ipTo) {
        ArrayList<String> ips = new ArrayList<String>();
        String[] ipfromd = ipFrom.split("\\.");
        String[] iptod = ipTo.split("\\.");
        int[] int_ipf = new int[4];
        int[] int_ipt = new int[4];
        for (int i = 0; i < 4; ++i) {
            int_ipf[i] = Integer.parseInt(ipfromd[i]);
            int_ipt[i] = Integer.parseInt(iptod[i]);
        }
        for (int A = int_ipf[0]; A <= int_ipt[0]; ++A) {
            for (int B = A == int_ipf[0] ? int_ipf[1] : 0; B <= (A == int_ipt[0] ? int_ipt[1] : 255); ++B) {
                for (int C = B == int_ipf[1] ? int_ipf[2] : 0; C <= (B == int_ipt[1] ? int_ipt[2] : 255); ++C) {
                    for (int D = C == int_ipf[2] ? int_ipf[3] : 0; D <= (C == int_ipt[2] ? int_ipt[3] : 255); ++D) {
                        ips.add(A + "." + B + "." + C + "." + D);
                    }
                }
            }
        }
        return ips;
    }

    public static String longIpToStr(Long ip) {
        String s1 = String.valueOf((ip & 0xFF000000L) / 0x1000000L);
        String s2 = String.valueOf((ip & 0xFF0000L) / 65536L);
        String s3 = String.valueOf((ip & 0xFF00L) / 256L);
        String s4 = String.valueOf(ip & 0xFFL);
        return s1 + "." + s2 + "." + s3 + "." + s4;
    }

    public static Long strIpToLong(String ip) {
        Long ipLong = 0L;
        String ipTemp = ip;
        ipLong = ipLong * 256L + Long.parseLong(ipTemp.substring(0, ipTemp.indexOf(".")));
        ipTemp = ipTemp.substring(ipTemp.indexOf(".") + 1);
        ipLong = ipLong * 256L + Long.parseLong(ipTemp.substring(0, ipTemp.indexOf(".")));
        ipTemp = ipTemp.substring(ipTemp.indexOf(".") + 1);
        ipLong = ipLong * 256L + Long.parseLong(ipTemp.substring(0, ipTemp.indexOf(".")));
        ipTemp = ipTemp.substring(ipTemp.indexOf(".") + 1);
        ipLong = ipLong * 256L + Long.parseLong(ipTemp);
        return ipLong;
    }

    public static String getMaskByMaskBit(String maskBit) {
        return StringUtils.isEmpty(maskBit) ? "error, maskBit is null !" : Ipv4Utils.maskBitMap().get(maskBit);
    }

    public static String getBeginIpStr(String ip, int maskBit) {
        return Ipv4Utils.longIpToStr(Ipv4Utils.getBeginIpLong(ip, maskBit));
    }

    private static Long getBeginIpLong(String ip, int maskBit) {
        return Ipv4Utils.strIpToLong(ip) & Ipv4Utils.strIpToLong(Ipv4Utils.getMaskByMaskBit(maskBit));
    }

    public static String getEndIpStr(String ip, int maskBit) {
        return Ipv4Utils.longIpToStr(Ipv4Utils.getEndIpLong(ip, maskBit));
    }

    private static Long getEndIpLong(String ip, int maskBit) {
        return Ipv4Utils.getBeginIpLong(ip, maskBit) + (Ipv4Utils.strIpToLong(Ipv4Utils.getMaskByMaskBit(maskBit)) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int getMaskBitByMask(String mask) {
        int inetmask = 0;
        int count = 0;
        String[] ipList = mask.split("\\.");
        for (int n = 0; n < ipList.length; ++n) {
            StringBuffer sbf = Ipv4Utils.toBin(Integer.parseInt(ipList[n]));
            String str = sbf.reverse().toString();
            count = 0;
            for (int i = 0; i < str.length() && (i = str.indexOf(49, i)) != -1; ++i) {
                ++count;
            }
            inetmask += count;
        }
        return inetmask;
    }

    public static int countByMaskBit(int maskBit, boolean isAll) {
        boolean isZero;
        boolean bl = isZero = !isAll && (maskBit <= 0 || maskBit >= 32);
        if (isZero) {
            return 0;
        }
        if (isAll) {
            return (int)Math.pow(2.0, 32 - maskBit);
        }
        return (int)Math.pow(2.0, 32 - maskBit) - 2;
    }

    private static StringBuffer toBin(int x) {
        StringBuffer result = new StringBuffer();
        result.append(x % 2);
        x /= 2;
        while (x > 0) {
            result.append(x % 2);
            x /= 2;
        }
        return result;
    }

    private static Map<String, String> maskBitMap() {
        HashMap<String, String> maskBit = new HashMap<String, String>(32);
        maskBit.put("1", "128.0.0.0");
        maskBit.put("2", "192.0.0.0");
        maskBit.put("3", "224.0.0.0");
        maskBit.put("4", "240.0.0.0");
        maskBit.put("5", "248.0.0.0");
        maskBit.put("6", "252.0.0.0");
        maskBit.put("7", "254.0.0.0");
        maskBit.put("8", "255.0.0.0");
        maskBit.put("9", "255.128.0.0");
        maskBit.put("10", "255.192.0.0");
        maskBit.put("11", "255.224.0.0");
        maskBit.put("12", "255.240.0.0");
        maskBit.put("13", "255.248.0.0");
        maskBit.put("14", "255.252.0.0");
        maskBit.put("15", "255.254.0.0");
        maskBit.put("16", "255.255.0.0");
        maskBit.put("17", "255.255.128.0");
        maskBit.put("18", "255.255.192.0");
        maskBit.put("19", "255.255.224.0");
        maskBit.put("20", "255.255.240.0");
        maskBit.put("21", "255.255.248.0");
        maskBit.put("22", "255.255.252.0");
        maskBit.put("23", "255.255.254.0");
        maskBit.put("24", "255.255.255.0");
        maskBit.put("25", "255.255.255.128");
        maskBit.put("26", "255.255.255.192");
        maskBit.put("27", "255.255.255.224");
        maskBit.put("28", "255.255.255.240");
        maskBit.put("29", "255.255.255.248");
        maskBit.put("30", "255.255.255.252");
        maskBit.put("31", "255.255.255.254");
        maskBit.put("32", "255.255.255.255");
        return maskBit;
    }

    public static String getMaskByMaskBit(int maskBit) {
        switch (maskBit) {
            case 1: {
                return "128.0.0.0";
            }
            case 2: {
                return "192.0.0.0";
            }
            case 3: {
                return "224.0.0.0";
            }
            case 4: {
                return "240.0.0.0";
            }
            case 5: {
                return "248.0.0.0";
            }
            case 6: {
                return "252.0.0.0";
            }
            case 7: {
                return "254.0.0.0";
            }
            case 8: {
                return "255.0.0.0";
            }
            case 9: {
                return "255.128.0.0";
            }
            case 10: {
                return "255.192.0.0";
            }
            case 11: {
                return "255.224.0.0";
            }
            case 12: {
                return "255.240.0.0";
            }
            case 13: {
                return "255.248.0.0";
            }
            case 14: {
                return "255.252.0.0";
            }
            case 15: {
                return "255.254.0.0";
            }
            case 16: {
                return "255.255.0.0";
            }
            case 17: {
                return "255.255.128.0";
            }
            case 18: {
                return "255.255.192.0";
            }
            case 19: {
                return "255.255.224.0";
            }
            case 20: {
                return "255.255.240.0";
            }
            case 21: {
                return "255.255.248.0";
            }
            case 22: {
                return "255.255.252.0";
            }
            case 23: {
                return "255.255.254.0";
            }
            case 24: {
                return "255.255.255.0";
            }
            case 25: {
                return "255.255.255.128";
            }
            case 26: {
                return "255.255.255.192";
            }
            case 27: {
                return "255.255.255.224";
            }
            case 28: {
                return "255.255.255.240";
            }
            case 29: {
                return "255.255.255.248";
            }
            case 30: {
                return "255.255.255.252";
            }
            case 31: {
                return "255.255.255.254";
            }
            case 32: {
                return "255.255.255.255";
            }
        }
        return "";
    }

    public static String getMaskByIpRange(String fromIp, String toIp) throws Exception {
        Long toIpLong = Ipv4Utils.strIpToLong(toIp);
        Long fromIpLong = Ipv4Utils.strIpToLong(fromIp);
        if (fromIpLong > toIpLong) {
            throw new Exception("\u5f00\u59cbIP\u5927\u4e0e\u7ed3\u675fIP");
        }
        String[] fromIpSplit = fromIp.split("\\.");
        String[] toIpSplit = toIp.split("\\.");
        StringBuilder mask = new StringBuilder();
        for (int i = 0; i < toIpSplit.length; ++i) {
            mask.append(255 - Integer.parseInt(toIpSplit[i]) + Integer.parseInt(fromIpSplit[i])).append(".");
        }
        return mask.substring(0, mask.length() - 1);
    }

    public static int countByIpRange(String fromIp, String toIp) throws Exception {
        Long toIpLong = Ipv4Utils.strIpToLong(toIp);
        Long fromIpLong = Ipv4Utils.strIpToLong(fromIp);
        if (fromIpLong > toIpLong) {
            throw new Exception("\u5f00\u59cbIP\u5927\u4e0e\u7ed3\u675fIP");
        }
        int count = 1;
        int[] fromIpSplit = Arrays.stream(fromIp.split("\\.")).mapToInt(Integer::parseInt).toArray();
        int[] toIpSplit = Arrays.stream(toIp.split("\\.")).mapToInt(Integer::parseInt).toArray();
        for (int i = fromIpSplit.length - 1; i >= 0; --i) {
            count = (int)((double)count + (double)(toIpSplit[i] - fromIpSplit[i]) * Math.pow(256.0, fromIpSplit.length - i - 1));
        }
        return count;
    }
}

