/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.net;

import com.github.jarvisframework.tool.core.util.CharUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;

public class URLDecoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte ESCAPE_CHAR = 37;

    public static String decode(String str, Charset charset) {
        return StringUtils.str(URLDecoder.decode(StringUtils.bytes((CharSequence)str, charset)), charset);
    }

    public static byte[] decode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 43) {
                buffer.write(32);
                continue;
            }
            if (b == 37) {
                int l;
                int u;
                if (i + 1 < bytes.length && (u = CharUtils.digit16(bytes[i + 1])) >= 0 && i + 2 < bytes.length && (l = CharUtils.digit16(bytes[i + 2])) >= 0) {
                    buffer.write((char)((u << 4) + l));
                    i += 2;
                    continue;
                }
                buffer.write(b);
                continue;
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }
}

