/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.net;

import com.github.jarvisframework.tool.core.util.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.BitSet;

public class URLEncoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final URLEncoder DEFAULT = URLEncoder.createDefault();
    public static final URLEncoder QUERY = URLEncoder.createQuery();
    public static final URLEncoder ALL = URLEncoder.createAll();
    private final BitSet safeCharacters;
    private boolean encodeSpaceAsPlus = false;

    public static URLEncoder createDefault() {
        URLEncoder encoder = new URLEncoder();
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        encoder.addSafeCharacter('~');
        encoder.addSafeCharacter('!');
        encoder.addSafeCharacter('$');
        encoder.addSafeCharacter('&');
        encoder.addSafeCharacter('\'');
        encoder.addSafeCharacter('(');
        encoder.addSafeCharacter(')');
        encoder.addSafeCharacter('*');
        encoder.addSafeCharacter('+');
        encoder.addSafeCharacter(',');
        encoder.addSafeCharacter(';');
        encoder.addSafeCharacter('=');
        encoder.addSafeCharacter(':');
        encoder.addSafeCharacter('@');
        encoder.addSafeCharacter('/');
        return encoder;
    }

    public static URLEncoder createQuery() {
        URLEncoder encoder = new URLEncoder();
        encoder.setEncodeSpaceAsPlus(true);
        encoder.addSafeCharacter('*');
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        encoder.addSafeCharacter('=');
        encoder.addSafeCharacter('&');
        return encoder;
    }

    public static URLEncoder createAll() {
        URLEncoder encoder = new URLEncoder();
        encoder.addSafeCharacter('*');
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        return encoder;
    }

    public URLEncoder() {
        this(new BitSet(256));
        char i;
        for (i = 'a'; i <= 'z'; i = (char)((char)(i + '\u0001'))) {
            this.addSafeCharacter(i);
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
        for (i = '0'; i <= '9'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
    }

    private URLEncoder(BitSet safeCharacters) {
        this.safeCharacters = safeCharacters;
    }

    public void addSafeCharacter(char c) {
        this.safeCharacters.set(c);
    }

    public void removeSafeCharacter(char c) {
        this.safeCharacters.clear(c);
    }

    public void setEncodeSpaceAsPlus(boolean encodeSpaceAsPlus) {
        this.encodeSpaceAsPlus = encodeSpaceAsPlus;
    }

    public String encode(String path, Charset charset) {
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, charset);
        for (int i = 0; i < path.length(); ++i) {
            byte[] ba;
            char c = path.charAt(i);
            if (this.safeCharacters.get(c)) {
                rewrittenPath.append(c);
                continue;
            }
            if (this.encodeSpaceAsPlus && c == ' ') {
                rewrittenPath.append('+');
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            for (byte toEncode : ba = buf.toByteArray()) {
                rewrittenPath.append('%');
                HexUtils.appendHex(rewrittenPath, toEncode, false);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }
}

