/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.net.url;

import com.github.jarvisframework.tool.core.collection.CollectionUtils;
import com.github.jarvisframework.tool.core.collection.IterUtils;
import com.github.jarvisframework.tool.core.convert.Convert;
import com.github.jarvisframework.tool.core.map.MapUtils;
import com.github.jarvisframework.tool.core.map.TableMap;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.core.util.UrlUtils;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;

public class UrlQuery {
    private final TableMap<CharSequence, CharSequence> query;

    public static UrlQuery of(Map<? extends CharSequence, ?> queryMap) {
        return new UrlQuery(queryMap);
    }

    public static UrlQuery of(String queryStr, Charset charset) {
        UrlQuery urlQuery = new UrlQuery();
        urlQuery.parse(queryStr, charset);
        return urlQuery;
    }

    public UrlQuery() {
        this(null);
    }

    public UrlQuery(Map<? extends CharSequence, ?> queryMap) {
        if (MapUtils.isNotEmpty(queryMap)) {
            this.query = new TableMap(queryMap.size());
            this.addAll(queryMap);
        } else {
            this.query = new TableMap(16);
        }
    }

    public UrlQuery add(CharSequence key, Object value) {
        this.query.put(key, UrlQuery.toStr(value));
        return this;
    }

    public UrlQuery addAll(Map<? extends CharSequence, ?> queryMap) {
        if (MapUtils.isNotEmpty(queryMap)) {
            queryMap.forEach(this::add);
        }
        return this;
    }

    public UrlQuery parse(String queryStr, Charset charset) {
        int i;
        if (StringUtils.isBlank(queryStr)) {
            return this;
        }
        int pathEndPos = queryStr.indexOf(63);
        if (pathEndPos > -1 && StringUtils.isBlank(queryStr = StringUtils.subSuf(queryStr, pathEndPos + 1))) {
            return this;
        }
        int len = queryStr.length();
        String name = null;
        int pos = 0;
        block4: for (i = 0; i < len; ++i) {
            char c = queryStr.charAt(i);
            switch (c) {
                case '=': {
                    if (null != name) continue block4;
                    name = queryStr.substring(pos, i);
                    pos = i + 1;
                    continue block4;
                }
                case '&': {
                    this.addParam(name, queryStr.substring(pos, i), charset);
                    name = null;
                    if (i + 4 < len && "amp;".equals(queryStr.substring(i + 1, i + 5))) {
                        i += 4;
                    }
                    pos = i + 1;
                }
            }
        }
        this.addParam(name, queryStr.substring(pos, i), charset);
        return this;
    }

    public Map<CharSequence, CharSequence> getQueryMap() {
        return MapUtils.unmodifiable(this.query);
    }

    public CharSequence get(CharSequence key) {
        if (MapUtils.isEmpty(this.query)) {
            return null;
        }
        return this.query.get(key);
    }

    public String build(Charset charset) {
        if (MapUtils.isEmpty(this.query)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<CharSequence, CharSequence> entry : this.query) {
            CharSequence key;
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            if (!StringUtils.isNotEmpty(key = entry.getKey())) continue;
            sb.append(UrlUtils.encodeAll(StringUtils.str(key), charset)).append("=");
            CharSequence value = entry.getValue();
            if (!StringUtils.isNotEmpty(value)) continue;
            sb.append(UrlUtils.encodeAll(StringUtils.str(value), charset));
        }
        return sb.toString();
    }

    public String toString() {
        return this.build(null);
    }

    private static String toStr(Object value) {
        String result = value instanceof Iterable ? CollectionUtils.join((Iterable)value, (CharSequence)",") : (value instanceof Iterator ? IterUtils.join((Iterator)value, (CharSequence)",") : Convert.toString(value));
        return result;
    }

    private void addParam(String key, String value, Charset charset) {
        if (null != key) {
            String actualKey = UrlUtils.decode(key, charset);
            this.query.put(actualKey, StringUtils.nullToEmpty(UrlUtils.decode(value, charset)));
        } else if (null != value) {
            this.query.put(UrlUtils.decode(value, charset), "");
        }
    }
}

