/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.text;

import com.github.jarvisframework.tool.core.text.StringBuilder;
import com.github.jarvisframework.tool.core.util.CharUtils;
import com.github.jarvisframework.tool.core.util.HexUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;

public class UnicodeUtils {
    public static String toString(String unicode) {
        int i;
        if (StringUtils.isBlank(unicode)) {
            return unicode;
        }
        int len = unicode.length();
        StringBuilder sb = StringBuilder.create(len);
        int pos = 0;
        while ((i = StringUtils.indexOfIgnoreCase(unicode, "\\u", pos)) != -1) {
            sb.append(unicode, pos, i);
            pos = i;
            if (i + 5 >= len) break;
            try {
                char c = (char)Integer.parseInt(unicode.substring(i + 2, i + 6), 16);
                sb.append(c);
                pos = i + 6;
            }
            catch (NumberFormatException e) {
                sb.append(unicode, pos, i + 2);
                pos = i + 2;
            }
        }
        if (pos < len) {
            sb.append(unicode, pos, len);
        }
        return sb.toString();
    }

    public static String toUnicode(String str) {
        return UnicodeUtils.toUnicode(str, true);
    }

    public static String toUnicode(String str, boolean isSkipAscii) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        StringBuilder unicode = StringBuilder.create(str.length() * 6);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (isSkipAscii && CharUtils.isAsciiPrintable(c)) {
                unicode.append(c);
                continue;
            }
            unicode.append(HexUtils.toUnicodeHex(c));
        }
        return unicode.toString();
    }
}

