/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.util;

import com.github.jarvisframework.tool.core.convert.BasicType;
import com.github.jarvisframework.tool.core.exception.UtilException;
import com.github.jarvisframework.tool.core.io.FileUtils;
import com.github.jarvisframework.tool.core.io.IORuntimeException;
import com.github.jarvisframework.tool.core.lang.Assert;
import com.github.jarvisframework.tool.core.lang.ClassScanner;
import com.github.jarvisframework.tool.core.lang.Filter;
import com.github.jarvisframework.tool.core.lang.Singleton;
import com.github.jarvisframework.tool.core.text.StringBuilder;
import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.CharsetUtils;
import com.github.jarvisframework.tool.core.util.ClassLoaderUtils;
import com.github.jarvisframework.tool.core.util.ReflectUtils;
import com.github.jarvisframework.tool.core.util.ResourceUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.core.util.TypeUtils;
import com.github.jarvisframework.tool.core.util.UrlUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ClassUtils {
    public static <T> Class<T> getClass(T obj) {
        return null == obj ? null : obj.getClass();
    }

    public static Class<?> getEnclosingClass(Class<?> clazz) {
        return null == clazz ? null : clazz.getEnclosingClass();
    }

    public static boolean isTopLevelClass(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return null == ClassUtils.getEnclosingClass(clazz);
    }

    public static String getClassName(Object obj, boolean isSimple) {
        if (null == obj) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        return ClassUtils.getClassName(clazz, isSimple);
    }

    public static String getClassName(Class<?> clazz, boolean isSimple) {
        if (null == clazz) {
            return null;
        }
        return isSimple ? clazz.getSimpleName() : clazz.getName();
    }

    public static String getShortClassName(String className) {
        List<String> packages = StringUtils.split((CharSequence)className, '.');
        if (null == packages || packages.size() < 2) {
            return className;
        }
        int size = packages.size();
        StringBuilder result = StringUtils.builder();
        result.append(packages.get(0).charAt(0));
        for (int i = 1; i < size - 1; ++i) {
            result.append('.').append(packages.get(i).charAt(0));
        }
        result.append('.').append(packages.get(size - 1));
        return result.toString();
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            classes[i] = null == obj ? Object.class : obj.getClass();
        }
        return classes;
    }

    public static boolean equals(Class<?> clazz, String className, boolean ignoreCase) {
        if (null == clazz || StringUtils.isBlank(className)) {
            return false;
        }
        if (ignoreCase) {
            return className.equalsIgnoreCase(clazz.getName()) || className.equalsIgnoreCase(clazz.getSimpleName());
        }
        return className.equals(clazz.getName()) || className.equals(clazz.getSimpleName());
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScanner.scanPackageByAnnotation(packageName, annotationClass);
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScanner.scanPackageBySuper(packageName, superClass);
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScanner.scanPackage();
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScanner.scanPackage(packageName);
    }

    public static Set<Class<?>> scanPackage(String packageName, Filter<Class<?>> classFilter) {
        return ClassScanner.scanPackage(packageName, classFilter);
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        return ReflectUtils.getPublicMethodNames(clazz);
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return ReflectUtils.getPublicMethods(clazz);
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Filter<Method> filter) {
        return ReflectUtils.getPublicMethods(clazz, filter);
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        return ReflectUtils.getPublicMethods(clazz, excludeMethods);
    }

    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        return ReflectUtils.getPublicMethods(clazz, excludeMethodNames);
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtils.getPublicMethod(clazz, methodName, paramTypes);
    }

    public static Set<String> getDeclaredMethodNames(Class<?> clazz) {
        return ReflectUtils.getMethodNames(clazz);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return ReflectUtils.getMethods(clazz);
    }

    public static Method getDeclaredMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        return ClassUtils.getDeclaredMethod(obj.getClass(), methodName, ClassUtils.getClasses(args));
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws SecurityException {
        return ReflectUtils.getMethod(clazz, methodName, parameterTypes);
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) throws SecurityException {
        if (null == clazz || StringUtils.isBlank(fieldName)) {
            return null;
        }
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        return clazz.getDeclaredFields();
    }

    public static Set<String> getClassPathResources() {
        return ClassUtils.getClassPathResources(false);
    }

    public static Set<String> getClassPathResources(boolean isDecode) {
        return ClassUtils.getClassPaths("", isDecode);
    }

    public static Set<String> getClassPaths(String packageName) {
        return ClassUtils.getClassPaths(packageName, false);
    }

    public static Set<String> getClassPaths(String packageName, boolean isDecode) {
        Enumeration<URL> resources;
        String packagePath = packageName.replace(".", "/");
        try {
            resources = ClassUtils.getClassLoader().getResources(packagePath);
        }
        catch (IOException e) {
            throw new UtilException(e, "Loading classPath [{}] error!", packagePath);
        }
        HashSet<String> paths = new HashSet<String>();
        while (resources.hasMoreElements()) {
            String path = resources.nextElement().getPath();
            paths.add(isDecode ? UrlUtils.decode(path, CharsetUtils.systemCharsetName()) : path);
        }
        return paths;
    }

    public static String getClassPath() {
        return ClassUtils.getClassPath(false);
    }

    public static String getClassPath(boolean isEncoded) {
        URL classPathUrl = ClassUtils.getClassPathUrl();
        String url = isEncoded ? classPathUrl.getPath() : UrlUtils.getDecodedPath(classPathUrl);
        return FileUtils.normalize(url);
    }

    public static URL getClassPathUrl() {
        return ClassUtils.getResourceUrl("");
    }

    public static URL getResourceUrl(String resource) throws IORuntimeException {
        return ResourceUtils.getResource(resource);
    }

    public static List<URL> getResources(String resource) {
        return ResourceUtils.getResources(resource);
    }

    public static URL getResourceUrl(String resource, Class<?> baseClass) {
        return ResourceUtils.getResource(resource, baseClass);
    }

    public static String[] getJavaClassPaths() {
        return System.getProperty("java.class.path").split(System.getProperty("path.separator"));
    }

    public static ClassLoader getContextClassLoader() {
        return ClassLoaderUtils.getContextClassLoader();
    }

    public static ClassLoader getClassLoader() {
        return ClassLoaderUtils.getClassLoader();
    }

    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if (ArrayUtils.isEmpty(types1) && ArrayUtils.isEmpty(types2)) {
            return true;
        }
        if (null == types1 || null == types2) {
            return false;
        }
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            Class<?> type1 = types1[i];
            Class<?> type2 = types2[i];
            if (!(ClassUtils.isBasicType(type1) && ClassUtils.isBasicType(type2) ? BasicType.unWrap(type1) != BasicType.unWrap(type2) : false == type1.isAssignableFrom(type2))) continue;
            return false;
        }
        return true;
    }

    public static <T> Class<T> loadClass(String className, boolean isInitialized) {
        return ClassLoaderUtils.loadClass(className, isInitialized);
    }

    public static <T> Class<T> loadClass(String className) {
        return ClassUtils.loadClass(className, true);
    }

    public static <T> T invoke(String classNameWithMethodName, Object[] args) {
        return ClassUtils.invoke(classNameWithMethodName, false, args);
    }

    public static <T> T invoke(String classNameWithMethodName, boolean isSingleton, Object ... args) {
        if (StringUtils.isBlank(classNameWithMethodName)) {
            throw new UtilException("Blank classNameDotMethodName!");
        }
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new UtilException("Invalid classNameWithMethodName [{}]!", classNameWithMethodName);
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        return ClassUtils.invoke(className, methodName, isSingleton, args);
    }

    public static <T> T invoke(String className, String methodName, Object[] args) {
        return ClassUtils.invoke(className, methodName, false, args);
    }

    public static <T> T invoke(String className, String methodName, boolean isSingleton, Object ... args) {
        Class<T> clazz = ClassUtils.loadClass(className);
        try {
            Method method = ClassUtils.getDeclaredMethod(clazz, methodName, ClassUtils.getClasses(args));
            if (null == method) {
                throw new NoSuchMethodException(StringUtils.format((CharSequence)"No such method: [{}]", methodName));
            }
            if (ClassUtils.isStatic(method)) {
                return ReflectUtils.invoke(null, method, args);
            }
            return ReflectUtils.invoke(isSingleton ? Singleton.get(clazz, new Object[0]) : clazz.newInstance(), method, args);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return BasicType.wrapperPrimitiveMap.containsKey(clazz);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isSimpleTypeOrArray(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return ClassUtils.isSimpleValueType(clazz) || clazz.isArray() && ClassUtils.isSimpleValueType(clazz.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> clazz) {
        return ClassUtils.isBasicType(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class) || TemporalAccessor.class.isAssignableFrom(clazz);
    }

    public static boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        if (null == targetType || null == sourceType) {
            return false;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            Class<?> resolvedPrimitive = BasicType.wrapperPrimitiveMap.get(sourceType);
            return targetType.equals(resolvedPrimitive);
        }
        Class<?> resolvedWrapper = BasicType.primitiveWrapperMap.get(sourceType);
        return resolvedWrapper != null && targetType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isPublic(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("Class to provided is null.");
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Method method) {
        Assert.notNull(method, "Method to provided is null.", new Object[0]);
        return Modifier.isPublic(method.getModifiers());
    }

    public static boolean isNotPublic(Class<?> clazz) {
        return false == ClassUtils.isPublic(clazz);
    }

    public static boolean isNotPublic(Method method) {
        return false == ClassUtils.isPublic(method);
    }

    public static boolean isStatic(Method method) {
        Assert.notNull(method, "Method to provided is null.", new Object[0]);
        return Modifier.isStatic(method.getModifiers());
    }

    public static Method setAccessible(Method method) {
        if (null != method && !method.isAccessible()) {
            method.setAccessible(true);
        }
        return method;
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && false == clazz.isInterface() && false == ClassUtils.isAbstract(clazz) && false == clazz.isEnum() && false == clazz.isArray() && false == clazz.isAnnotation() && false == clazz.isSynthetic() && false == clazz.isPrimitive();
    }

    public static boolean isEnum(Class<?> clazz) {
        return null != clazz && clazz.isEnum();
    }

    public static Class<?> getTypeArgument(Class<?> clazz) {
        return ClassUtils.getTypeArgument(clazz, 0);
    }

    public static Class<?> getTypeArgument(Class<?> clazz, int index) {
        Type argumentType = TypeUtils.getTypeArgument(clazz, index);
        if (argumentType instanceof Class) {
            return (Class)argumentType;
        }
        return null;
    }

    public static String getPackage(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(".");
        if (packageEndIndex == -1) {
            return "";
        }
        return className.substring(0, packageEndIndex);
    }

    public static String getPackagePath(Class<?> clazz) {
        return ClassUtils.getPackage(clazz).replace('.', '/');
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (Long.TYPE == clazz) {
                return 0L;
            }
            if (Integer.TYPE == clazz) {
                return 0;
            }
            if (Short.TYPE == clazz) {
                return (short)0;
            }
            if (Character.TYPE == clazz) {
                return Character.valueOf('\u0000');
            }
            if (Byte.TYPE == clazz) {
                return (byte)0;
            }
            if (Double.TYPE == clazz) {
                return 0.0;
            }
            if (Float.TYPE == clazz) {
                return Float.valueOf(0.0f);
            }
            if (Boolean.TYPE == clazz) {
                return false;
            }
        }
        return null;
    }

    public static Object[] getDefaultValues(Class<?> ... classes) {
        Object[] values = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            values[i] = ClassUtils.getDefaultValue(classes[i]);
        }
        return values;
    }

    public static boolean isJdkClass(Class<?> clazz) {
        Package objectPackage = clazz.getPackage();
        if (null == objectPackage) {
            return false;
        }
        String objectPackageName = objectPackage.getName();
        return objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || clazz.getClassLoader() == null;
    }

    public static URL getLocation(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        return clazz.getProtectionDomain().getCodeSource().getLocation();
    }

    public static String getLocationPath(Class<?> clazz) {
        URL location = ClassUtils.getLocation(clazz);
        if (null == location) {
            return null;
        }
        return location.getPath();
    }
}

