/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.util;

import com.github.jarvisframework.tool.core.SnowflakeIdWorker;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReentrantLock;

public class IdCreateUtils {
    private static final SnowflakeIdWorker ID_WORKER = new SnowflakeIdWorker();
    private static boolean IS_THREAD_LOCAL_RANDOM_AVAILABLE = false;
    private static Random random;
    private static final long LEAST_SIG_BITS;
    private static final ReentrantLock LOCKER;
    private static long lastTime;

    private IdCreateUtils() {
    }

    public static long createWorkId() {
        return ID_WORKER.nextId();
    }

    public static BigInteger createBigIntId() {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        return new BigInteger(uuid, 16);
    }

    public static BigInteger createRandomBigIntId() {
        return new BigInteger(IdCreateUtils.createTimeBasedUUIDStr().getBytes());
    }

    public static String createUUIDStr() {
        return UUID.randomUUID().toString();
    }

    public static String createRandomBasedUUIDStr() {
        byte[] randomBytes = new byte[16];
        if (IS_THREAD_LOCAL_RANDOM_AVAILABLE) {
            ThreadLocalRandom.current().nextBytes(randomBytes);
        } else {
            random.nextBytes(randomBytes);
        }
        long mostSigBits = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSigBits = mostSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        long leastSigBits = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSigBits = leastSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return new UUID(mostSigBits, leastSigBits).toString().replaceAll("-", "");
    }

    public static String createTimeBasedUUIDStr() {
        long timeMillis = System.currentTimeMillis() * 10000L + 122192928000000000L;
        LOCKER.lock();
        try {
            if (timeMillis > lastTime) {
                lastTime = timeMillis;
            } else {
                timeMillis = ++lastTime;
            }
        }
        finally {
            LOCKER.unlock();
        }
        long mostSigBits = timeMillis << 32;
        mostSigBits |= (timeMillis & 0xFFFF00000000L) >> 16;
        return new UUID(mostSigBits |= 0x1000L | timeMillis >> 48 & 0xFFFL, LEAST_SIG_BITS).toString().replaceAll("-", "");
    }

    static {
        LOCKER = new ReentrantLock();
        try {
            IS_THREAD_LOCAL_RANDOM_AVAILABLE = null != IdCreateUtils.class.getClassLoader().loadClass("java.util.concurrent.ThreadLocalRandom");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        byte[] seed = new SecureRandom().generateSeed(8);
        LEAST_SIG_BITS = new BigInteger(seed).longValue();
        if (!IS_THREAD_LOCAL_RANDOM_AVAILABLE) {
            random = new Random(LEAST_SIG_BITS);
        }
    }
}

