/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.util;

import com.github.jarvisframework.tool.core.collection.CollectionUtils;
import com.github.jarvisframework.tool.core.convert.Convert;
import com.github.jarvisframework.tool.core.exception.UtilException;
import com.github.jarvisframework.tool.core.lang.Holder;
import com.github.jarvisframework.tool.core.lang.PatternPool;
import com.github.jarvisframework.tool.core.lang.func.Func1;
import com.github.jarvisframework.tool.core.util.ObjectUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtils {
    public static final String RE_CHINESE = "[\u4e00-\u9fff]";
    public static final String RE_CHINESE_STR = "[\u4e00-\u9fff]+";
    public static final Set<Character> RE_KEYS = CollectionUtils.newHashSet(Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'));

    public static String getGroup0(String regex, CharSequence content) {
        return RegexUtils.get(regex, content, 0);
    }

    public static String getGroup1(String regex, CharSequence content) {
        return RegexUtils.get(regex, content, 1);
    }

    public static String get(String regex, CharSequence content, int groupIndex) {
        if (null == content || null == regex) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.get(pattern, content, groupIndex);
    }

    public static String getGroup0(Pattern pattern, CharSequence content) {
        return RegexUtils.get(pattern, content, 0);
    }

    public static String getGroup1(Pattern pattern, CharSequence content) {
        return RegexUtils.get(pattern, content, 1);
    }

    public static String get(Pattern pattern, CharSequence content, int groupIndex) {
        if (null == content || null == pattern) {
            return null;
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content) {
        return RegexUtils.getAllGroups(pattern, content, true);
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content, boolean withGroup0) {
        if (null == content || null == pattern) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            int startGroup = withGroup0 ? 0 : 1;
            int groupCount = matcher.groupCount();
            for (int i = startGroup; i <= groupCount; ++i) {
                result.add(matcher.group(i));
            }
        }
        return result;
    }

    public static String extractMulti(Pattern pattern, CharSequence content, String template) {
        if (null == content || null == pattern || null == template) {
            return null;
        }
        TreeSet<Integer> varNums = new TreeSet<Integer>((o1, o2) -> ObjectUtils.compare(o2, o1));
        Matcher matcherForTemplate = PatternPool.GROUP_VAR.matcher(template);
        while (matcherForTemplate.find()) {
            varNums.add(Integer.parseInt(matcherForTemplate.group(1)));
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (Integer group : varNums) {
                template = template.replace("$" + group, matcher.group(group));
            }
            return template;
        }
        return null;
    }

    public static String extractMulti(String regex, CharSequence content, String template) {
        if (null == content || null == regex || null == template) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.extractMulti(pattern, content, template);
    }

    public static String extractMultiAndDelPre(Pattern pattern, Holder<CharSequence> contentHolder, String template) {
        if (null == contentHolder || null == pattern || null == template) {
            return null;
        }
        HashSet<String> varNums = RegexUtils.findAll(PatternPool.GROUP_VAR, (CharSequence)template, 1, new HashSet());
        CharSequence content = (CharSequence)contentHolder.get();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (String var : varNums) {
                int group = Integer.parseInt(var);
                template = template.replace("$" + var, matcher.group(group));
            }
            contentHolder.set(StringUtils.sub(content, matcher.end(), content.length()));
            return template;
        }
        return null;
    }

    public static String extractMultiAndDelPre(String regex, Holder<CharSequence> contentHolder, String template) {
        if (null == contentHolder || null == regex || null == template) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.extractMultiAndDelPre(pattern, contentHolder, template);
    }

    public static String delFirst(String regex, CharSequence content) {
        if (StringUtils.hasBlank(regex, content)) {
            return StringUtils.str(content);
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.delFirst(pattern, content);
    }

    public static String delFirst(Pattern pattern, CharSequence content) {
        if (null == pattern || StringUtils.isBlank(content)) {
            return StringUtils.str(content);
        }
        return pattern.matcher(content).replaceFirst("");
    }

    public static String delAll(String regex, CharSequence content) {
        if (StringUtils.hasBlank(regex, content)) {
            return StringUtils.str(content);
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.delAll(pattern, content);
    }

    public static String delAll(Pattern pattern, CharSequence content) {
        if (null == pattern || StringUtils.isBlank(content)) {
            return StringUtils.str(content);
        }
        return pattern.matcher(content).replaceAll("");
    }

    public static String delPre(String regex, CharSequence content) {
        if (null == content || null == regex) {
            return StringUtils.str(content);
        }
        Pattern pattern = PatternPool.get(regex, 32);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return StringUtils.sub(content, matcher.end(), content.length());
        }
        return StringUtils.str(content);
    }

    public static List<String> findAllGroup0(String regex, CharSequence content) {
        return RegexUtils.findAll(regex, content, 0);
    }

    public static List<String> findAllGroup1(String regex, CharSequence content) {
        return RegexUtils.findAll(regex, content, 1);
    }

    public static List<String> findAll(String regex, CharSequence content, int group) {
        return RegexUtils.findAll(regex, content, group, new ArrayList());
    }

    public static <T extends Collection<String>> T findAll(String regex, CharSequence content, int group, T collection) {
        if (null == regex) {
            return collection;
        }
        return RegexUtils.findAll(Pattern.compile(regex, 32), content, group, collection);
    }

    public static List<String> findAllGroup0(Pattern pattern, CharSequence content) {
        return RegexUtils.findAll(pattern, content, 0);
    }

    public static List<String> findAllGroup1(Pattern pattern, CharSequence content) {
        return RegexUtils.findAll(pattern, content, 1);
    }

    public static List<String> findAll(Pattern pattern, CharSequence content, int group) {
        return RegexUtils.findAll(pattern, content, group, new ArrayList());
    }

    public static <T extends Collection<String>> T findAll(Pattern pattern, CharSequence content, int group, T collection) {
        if (null == pattern || null == content) {
            return null;
        }
        if (null == collection) {
            throw new NullPointerException("Null collection param provided!");
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            collection.add((String)matcher.group(group));
        }
        return collection;
    }

    public static int count(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return 0;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.count(pattern, content);
    }

    public static int count(Pattern pattern, CharSequence content) {
        if (null == pattern || null == content) {
            return 0;
        }
        int count = 0;
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static boolean contains(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return false;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.contains(pattern, content);
    }

    public static boolean contains(Pattern pattern, CharSequence content) {
        if (null == pattern || null == content) {
            return false;
        }
        return pattern.matcher(content).find();
    }

    public static Integer getFirstNumber(CharSequence stringWithNumber) {
        return Convert.toInt(RegexUtils.get(PatternPool.NUMBERS, stringWithNumber, 0), null);
    }

    public static boolean isMatch(String regex, CharSequence content) {
        if (content == null) {
            return false;
        }
        if (StringUtils.isEmpty(regex)) {
            return true;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.isMatch(pattern, content);
    }

    public static boolean isMatch(Pattern pattern, CharSequence content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static String replaceAll(CharSequence content, String regex, String replacementTemplate) {
        Pattern pattern = Pattern.compile(regex, 32);
        return RegexUtils.replaceAll(content, pattern, replacementTemplate);
    }

    public static String replaceAll(CharSequence content, Pattern pattern, String replacementTemplate) {
        if (StringUtils.isEmpty(content)) {
            return StringUtils.str(content);
        }
        Matcher matcher = pattern.matcher(content);
        boolean result = matcher.find();
        if (result) {
            Set varNums = RegexUtils.findAll(PatternPool.GROUP_VAR, (CharSequence)replacementTemplate, 1, new HashSet());
            StringBuffer sb = new StringBuffer();
            do {
                String replacement = replacementTemplate;
                for (String var : varNums) {
                    int group = Integer.parseInt(var);
                    replacement = replacement.replace("$" + var, matcher.group(group));
                }
                matcher.appendReplacement(sb, RegexUtils.escape(replacement));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return StringUtils.str(content);
    }

    public static String replaceAll(CharSequence str, String regex, Func1<Matcher, String> replaceFun) {
        return RegexUtils.replaceAll(str, Pattern.compile(regex), replaceFun);
    }

    public static String replaceAll(CharSequence str, Pattern pattern, Func1<Matcher, String> replaceFun) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        Matcher matcher = pattern.matcher(str);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            try {
                matcher.appendReplacement(buffer, replaceFun.call(matcher));
            }
            catch (Exception e) {
                throw new UtilException(e);
            }
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String escape(char c) {
        StringBuilder builder = new StringBuilder();
        if (RE_KEYS.contains(Character.valueOf(c))) {
            builder.append('\\');
        }
        builder.append(c);
        return builder.toString();
    }

    public static String escape(CharSequence content) {
        if (StringUtils.isBlank(content)) {
            return StringUtils.str(content);
        }
        StringBuilder builder = new StringBuilder();
        int len = content.length();
        for (int i = 0; i < len; ++i) {
            char current = content.charAt(i);
            if (RE_KEYS.contains(Character.valueOf(current))) {
                builder.append('\\');
            }
            builder.append(current);
        }
        return builder.toString();
    }
}

