/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.util;

import com.github.jarvisframework.tool.core.collection.CollectionUtils;
import com.github.jarvisframework.tool.core.collection.EnumerationIter;
import com.github.jarvisframework.tool.core.io.FileUtils;
import com.github.jarvisframework.tool.core.io.IORuntimeException;
import com.github.jarvisframework.tool.core.io.resource.ClassPathResource;
import com.github.jarvisframework.tool.core.io.resource.FileResource;
import com.github.jarvisframework.tool.core.io.resource.NoResourceException;
import com.github.jarvisframework.tool.core.io.resource.Resource;
import com.github.jarvisframework.tool.core.util.CharsetUtils;
import com.github.jarvisframework.tool.core.util.ClassLoaderUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;

public class ResourceUtils {
    public static String readUtf8Str(String resource) {
        return ResourceUtils.getResourceObj(resource).readUtf8Str();
    }

    public static String readStr(String resource, Charset charset) {
        return ResourceUtils.getResourceObj(resource).readStr(charset);
    }

    public static byte[] readBytes(String resource) {
        return ResourceUtils.getResourceObj(resource).readBytes();
    }

    public static InputStream getStream(String resource) throws NoResourceException {
        return ResourceUtils.getResourceObj(resource).getStream();
    }

    public static InputStream getStreamSafe(String resource) {
        try {
            return ResourceUtils.getResourceObj(resource).getStream();
        }
        catch (NoResourceException noResourceException) {
            return null;
        }
    }

    public static BufferedReader getUtf8Reader(String resource) {
        return ResourceUtils.getReader(resource, CharsetUtils.CHARSET_UTF_8);
    }

    public static BufferedReader getReader(String resource, Charset charset) {
        return ResourceUtils.getResourceObj(resource).getReader(charset);
    }

    public static URL getResource(String resource) throws IORuntimeException {
        return ResourceUtils.getResource(resource, null);
    }

    public static List<URL> getResources(String resource) {
        Enumeration<URL> resources;
        try {
            resources = ClassLoaderUtils.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return CollectionUtils.newArrayList(resources);
    }

    public static EnumerationIter<URL> getResourceIter(String resource) {
        Enumeration<URL> resources;
        try {
            resources = ClassLoaderUtils.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return new EnumerationIter<URL>(resources);
    }

    public static URL getResource(String resource, Class<?> baseClass) {
        return null != baseClass ? baseClass.getResource(resource) : ClassLoaderUtils.getClassLoader().getResource(resource);
    }

    public static Resource getResourceObj(String path) {
        if (StringUtils.isNotBlank(path) && (path.startsWith("file:") || FileUtils.isAbsolutePath(path))) {
            return new FileResource(path);
        }
        return new ClassPathResource(path);
    }
}

