/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.util;

import com.github.jarvisframework.tool.core.exception.UtilException;
import com.github.jarvisframework.tool.core.io.IORuntimeException;
import com.github.jarvisframework.tool.core.io.IOUtils;
import com.github.jarvisframework.tool.core.lang.Assert;
import com.github.jarvisframework.tool.core.net.URLDecoder;
import com.github.jarvisframework.tool.core.net.URLEncoder;
import com.github.jarvisframework.tool.core.net.url.UrlQuery;
import com.github.jarvisframework.tool.core.text.StringBuilder;
import com.github.jarvisframework.tool.core.util.CharUtils;
import com.github.jarvisframework.tool.core.util.CharsetUtils;
import com.github.jarvisframework.tool.core.util.ClassLoaderUtils;
import com.github.jarvisframework.tool.core.util.ResourceUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.jar.JarFile;

public class UrlUtils {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String WAR_URL_PREFIX = "war:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String WAR_URL_SEPARATOR = "*/";

    public static URL url(String url) {
        return UrlUtils.url(url, null);
    }

    public static URL url(String url, URLStreamHandler handler) {
        Assert.notNull(url, "URL must not be null", new Object[0]);
        if (url.startsWith(CLASSPATH_URL_PREFIX)) {
            url = url.substring(CLASSPATH_URL_PREFIX.length());
            return ClassLoaderUtils.getClassLoader().getResource(url);
        }
        try {
            return new URL(null, url, handler);
        }
        catch (MalformedURLException e) {
            try {
                return new File(url).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new UtilException(e);
            }
        }
    }

    public static URL toUrlForHttp(String urlStr) {
        return UrlUtils.toUrlForHttp(urlStr, null);
    }

    public static URL toUrlForHttp(String urlStr, URLStreamHandler handler) {
        Assert.notBlank(urlStr, "Url is blank !", new Object[0]);
        urlStr = UrlUtils.encodeBlank(urlStr);
        try {
            return new URL(null, urlStr, handler);
        }
        catch (MalformedURLException e) {
            throw new UtilException(e);
        }
    }

    public static String encodeBlank(CharSequence urlStr) {
        if (urlStr == null) {
            return null;
        }
        int len = urlStr.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = urlStr.charAt(i);
            if (CharUtils.isBlankChar(c)) {
                sb.append("%20");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static URL getURL(String pathBaseClassLoader) {
        return ResourceUtils.getResource(pathBaseClassLoader);
    }

    public static URL getURL(String path, Class<?> clazz) {
        return ResourceUtils.getResource(path, clazz);
    }

    public static URL getURL(File file) {
        Assert.notNull(file, "File is null !", new Object[0]);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UtilException(e, "Error occured when get URL!", new Object[0]);
        }
    }

    public static URL[] getURLs(File ... files) {
        URL[] urls = new URL[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new UtilException(e, "Error occured when get URL!", new Object[0]);
        }
        return urls;
    }

    public static URI getHost(URL url) {
        if (null == url) {
            return null;
        }
        try {
            return new URI(url.getProtocol(), url.getHost(), null, null);
        }
        catch (URISyntaxException e) {
            throw new UtilException(e);
        }
    }

    @Deprecated
    public static String complateUrl(String baseUrl, String relativePath) {
        return UrlUtils.completeUrl(baseUrl, relativePath);
    }

    public static String completeUrl(String baseUrl, String relativePath) {
        if (StringUtils.isBlank(baseUrl = UrlUtils.normalize(baseUrl, false))) {
            return null;
        }
        try {
            URL absoluteUrl = new URL(baseUrl);
            URL parseUrl = new URL(absoluteUrl, relativePath);
            return parseUrl.toString();
        }
        catch (MalformedURLException e) {
            throw new UtilException(e);
        }
    }

    public static String encodeAll(String url) {
        return UrlUtils.encodeAll(url, CharsetUtils.CHARSET_UTF_8);
    }

    public static String encodeAll(String url, Charset charset) throws UtilException {
        if (null == charset) {
            return url;
        }
        return URLEncoder.ALL.encode(url, charset);
    }

    public static String encode(String url) throws UtilException {
        return UrlUtils.encode(url, CharsetUtils.CHARSET_UTF_8);
    }

    public static String encodeQuery(String url) throws UtilException {
        return UrlUtils.encodeQuery(url, CharsetUtils.CHARSET_UTF_8);
    }

    public static String encode(String url, Charset charset) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        if (null == charset) {
            charset = CharsetUtils.defaultCharset();
        }
        return URLEncoder.DEFAULT.encode(url, charset);
    }

    public static String encodeQuery(String url, Charset charset) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        if (null == charset) {
            charset = CharsetUtils.defaultCharset();
        }
        return URLEncoder.QUERY.encode(url, charset);
    }

    public static String encode(String url, String charset) throws UtilException {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        return UrlUtils.encode(url, StringUtils.isBlank(charset) ? CharsetUtils.defaultCharset() : CharsetUtils.charset(charset));
    }

    public static String encodeQuery(String url, String charset) throws UtilException {
        return UrlUtils.encodeQuery(url, StringUtils.isBlank(charset) ? CharsetUtils.defaultCharset() : CharsetUtils.charset(charset));
    }

    public static String decode(String url) throws UtilException {
        return UrlUtils.decode(url, "UTF-8");
    }

    public static String decode(String content, Charset charset) {
        if (null == charset) {
            return content;
        }
        return URLDecoder.decode(content, charset);
    }

    public static String decode(String content, String charset) throws UtilException {
        return UrlUtils.decode(content, CharsetUtils.charset(charset));
    }

    public static String getPath(String uriStr) {
        URI uri;
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new UtilException(e);
        }
        return uri.getPath();
    }

    public static String getDecodedPath(URL url) {
        if (null == url) {
            return null;
        }
        String path = null;
        try {
            path = UrlUtils.toURI(url).getPath();
        }
        catch (UtilException utilException) {
            // empty catch block
        }
        return null != path ? path : url.getPath();
    }

    public static URI toURI(URL url) throws UtilException {
        return UrlUtils.toURI(url, false);
    }

    public static URI toURI(URL url, boolean isEncode) throws UtilException {
        if (null == url) {
            return null;
        }
        return UrlUtils.toURI(url.toString(), isEncode);
    }

    public static URI toURI(String location) throws UtilException {
        return UrlUtils.toURI(location, false);
    }

    public static URI toURI(String location, boolean isEncode) throws UtilException {
        if (isEncode) {
            location = UrlUtils.encode(location);
        }
        try {
            return new URI(location);
        }
        catch (URISyntaxException e) {
            throw new UtilException(e);
        }
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol);
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol);
    }

    public static boolean isJarFileURL(URL url) {
        return URL_PROTOCOL_FILE.equals(url.getProtocol()) && url.getPath().toLowerCase().endsWith(".jar");
    }

    public static InputStream getStream(URL url) {
        Assert.notNull(url);
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedReader getReader(URL url, Charset charset) {
        return IOUtils.getReader(UrlUtils.getStream(url), charset);
    }

    public static JarFile getJarFile(URL url) {
        try {
            JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
            return urlConnection.getJarFile();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String normalize(String url) {
        return UrlUtils.normalize(url, false);
    }

    public static String normalize(String url, boolean isEncodePath) {
        String body;
        String protocol;
        if (StringUtils.isBlank(url)) {
            return url;
        }
        int sepIndex = url.indexOf("://");
        if (sepIndex > 0) {
            protocol = StringUtils.subPre(url, sepIndex + 3);
            body = StringUtils.subSuf(url, sepIndex + 3);
        } else {
            protocol = "http://";
            body = url;
        }
        int paramsSepIndex = StringUtils.indexOf(body, '?');
        String params = null;
        if (paramsSepIndex > 0) {
            params = StringUtils.subSuf(body, paramsSepIndex);
            body = StringUtils.subPre(body, paramsSepIndex);
        }
        if (StringUtils.isNotEmpty(body)) {
            body = body.replaceAll("^[\\\\/]+", "");
            body = body.replace("\\", "/").replaceAll("//+", "/");
        }
        int pathSepIndex = StringUtils.indexOf(body, '/');
        String domain = body;
        String path = null;
        if (pathSepIndex > 0) {
            domain = StringUtils.subPre(body, pathSepIndex);
            path = StringUtils.subSuf(body, pathSepIndex);
        }
        if (isEncodePath) {
            path = UrlUtils.encode(path);
        }
        return protocol + domain + StringUtils.nullToEmpty(path) + StringUtils.nullToEmpty(params);
    }

    public static String buildQuery(Map<String, ?> paramMap, Charset charset) {
        return UrlQuery.of(paramMap).build(charset);
    }

    public static long getContentLength(URL url) throws IORuntimeException {
        if (null == url) {
            return -1L;
        }
        URLConnection conn = null;
        try {
            conn = url.openConnection();
            long l = conn.getContentLengthLong();
            return l;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
    }

    public static String getDataUri(String mimeType, String encoding, String data) {
        return UrlUtils.getDataUri(mimeType, null, encoding, data);
    }

    public static String getDataUri(String mimeType, Charset charset, String encoding, String data) {
        StringBuilder builder = StringUtils.builder("data:");
        if (StringUtils.isNotBlank(mimeType)) {
            builder.append(mimeType);
        }
        if (null != charset) {
            builder.append(";charset=").append(charset.name());
        }
        if (StringUtils.isNotBlank(encoding)) {
            builder.append(';').append(encoding);
        }
        builder.append(',').append(data);
        return builder.toString();
    }
}

