/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.util;

import com.github.jarvisframework.tool.core.date.DateTimeUtils;
import com.github.jarvisframework.tool.core.exception.XmlParseException;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.TimeZone;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.InputSource;

public abstract class XmlParseUtils {
    private static final String XML_TAG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final XmlFriendlyNameCoder NAME_CODER = new XmlFriendlyNameCoder("_-", "_");
    private static DomDriver DOM_DRIVER = new DomDriver("UTF-8", (NameCoder)NAME_CODER);
    private static final DateConverter DATE_CONVERTER = new DateConverter(DateTimeUtils.DateTimeFormat.LONG_DATE_PATTERN_LINE.getPattern(), null, TimeZone.getTimeZone("GMT+8"));
    private static XStream instance = null;

    private XmlParseUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final XStream getInstance() {
        if (null != instance) return instance;
        Class<XmlParseUtils> clazz = XmlParseUtils.class;
        synchronized (XmlParseUtils.class) {
            if (null != instance) return instance;
            instance = new XStream((HierarchicalStreamDriver)DOM_DRIVER);
            instance.aliasSystemAttribute(null, "class");
            instance.autodetectAnnotations(true);
            instance.ignoreUnknownElements();
            XStream.setupDefaultSecurity((XStream)instance);
            instance.allowTypesByWildcard(new String[]{"com.yx.**"});
            instance.setClassLoader(XmlParseUtils.class.getClassLoader());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static final String getText(String xmlStr, String xpathStr) {
        Document document = XmlParseUtils.getDocumentFromXmlString(xmlStr);
        Node node = document.selectSingleNode(xpathStr);
        return null == node ? null : node.getText();
    }

    public static final String getText(Element e, String tag) {
        Element element = e.element(tag);
        if (null != element) {
            return element.getText();
        }
        return null;
    }

    public static final Document getDocumentFromXmlString(String xmlStr) {
        try {
            return DocumentHelper.parseText((String)xmlStr);
        }
        catch (DocumentException e) {
            throw new XmlParseException(e.getMessage());
        }
    }

    public static String beanToXml(String rootTagName, Object object) throws XmlParseException {
        String xmlStr = XmlParseUtils.beanToXml(object);
        Document document = XmlParseUtils.getDocumentFromXmlString(xmlStr);
        Element rootElement = document.getRootElement();
        rootElement.setName(rootTagName);
        xmlStr = XmlParseUtils.DocumentToXml(document, true);
        return xmlStr;
    }

    public static String beanToXml(Object object) throws XmlParseException {
        return XmlParseUtils.beanToXml(object, true);
    }

    public static String beanToXml(Object object, boolean isCompress) throws XmlParseException {
        XStream xStream = XmlParseUtils.getInstance();
        try {
            String xmlStr;
            if (isCompress) {
                StringWriter sw = new StringWriter();
                xStream.marshal(object, (HierarchicalStreamWriter)new CompactWriter((Writer)sw));
                xmlStr = sw.toString().replace("__", "_");
            } else {
                xmlStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xStream.toXML(object);
            }
            return xmlStr;
        }
        catch (Exception e) {
            throw new XmlParseException(e.getMessage());
        }
    }

    public static void beanToXmlFile(Object obj, File file) throws XmlParseException {
        XmlParseUtils.beanToXmlFile(XmlParseUtils.beanToXml(obj), file);
    }

    public static void beanToXmlFile(String xml, File file) throws XmlParseException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            InputSource is = new InputSource(new ByteArrayInputStream(xml.getBytes()));
            SAXSource xmlSource = new SAXSource(is);
            transformer.transform(xmlSource, new StreamResult(file));
        }
        catch (Exception e) {
            throw new XmlParseException(e.getMessage());
        }
    }

    public static String DocumentToXml(Document document, boolean isCompress) throws XmlParseException {
        StringWriter stringWriter = new StringWriter();
        OutputFormat outputFormat = isCompress ? OutputFormat.createCompactFormat() : OutputFormat.createPrettyPrint();
        outputFormat.setSuppressDeclaration(true);
        outputFormat.setEncoding("UTF-8");
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, outputFormat);
        try {
            xmlWriter.write(document);
        }
        catch (IOException e) {
            throw new XmlParseException(e.getMessage());
        }
        finally {
            try {
                xmlWriter.flush();
                xmlWriter.close();
            }
            catch (IOException e) {
                throw new XmlParseException(e.getMessage());
            }
        }
        return stringWriter.toString();
    }

    public static <T> T xmlToBean(String xmlStr, String rootTagName, Class<T> clazz) throws XmlParseException {
        Document document = XmlParseUtils.getDocumentFromXmlString(xmlStr);
        Element rootElement = document.getRootElement();
        rootElement.setName(rootTagName);
        xmlStr = XmlParseUtils.DocumentToXml(document, true);
        return XmlParseUtils.xmlToBean(xmlStr, clazz);
    }

    public static <T> T xmlToBean(String xmlStr, Class<T> clazz) throws XmlParseException {
        XStream xStream = XmlParseUtils.getInstance();
        xStream.processAnnotations(clazz);
        try {
            Object object = xStream.fromXML(xmlStr);
            T cast = clazz.cast(object);
            return cast;
        }
        catch (Exception e) {
            throw new XmlParseException(e.getMessage());
        }
    }

    public static <T> T xmlToBean(Reader reader, Class<T> clazz) throws XmlParseException {
        XStream xStream = XmlParseUtils.getInstance();
        xStream.processAnnotations(clazz);
        try {
            Object object = xStream.fromXML(reader);
            T cast = clazz.cast(object);
            return cast;
        }
        catch (Exception e) {
            throw new XmlParseException(e.getMessage());
        }
    }

    public static <T> T xmlToBean(InputStream input, Class<T> clazz) throws XmlParseException {
        XStream xStream = XmlParseUtils.getInstance();
        xStream.processAnnotations(clazz);
        try {
            Object object = xStream.fromXML(input);
            T cast = clazz.cast(object);
            return cast;
        }
        catch (Exception e) {
            throw new XmlParseException(e.getMessage());
        }
    }

    public static <T> T xmlToBean(URL url, Class<T> clazz) throws XmlParseException {
        XStream xStream = XmlParseUtils.getInstance();
        xStream.processAnnotations(clazz);
        try {
            Object object = xStream.fromXML(url);
            T cast = clazz.cast(object);
            return cast;
        }
        catch (Exception e) {
            throw new XmlParseException(e.getMessage());
        }
    }

    public static <T> T xmlToBean(File file, Class<T> clazz) throws XmlParseException {
        XStream xStream = XmlParseUtils.getInstance();
        xStream.processAnnotations(clazz);
        try {
            Object object = xStream.fromXML(file);
            T cast = clazz.cast(object);
            return cast;
        }
        catch (Exception e) {
            throw new XmlParseException(e.getMessage());
        }
    }
}

