/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.core.util;

import com.github.jarvisframework.tool.core.exception.UtilException;
import com.github.jarvisframework.tool.core.io.FastByteArrayOutputStream;
import com.github.jarvisframework.tool.core.io.FileUtils;
import com.github.jarvisframework.tool.core.io.IORuntimeException;
import com.github.jarvisframework.tool.core.io.IOUtils;
import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.CharsetUtils;
import com.github.jarvisframework.tool.core.util.ObjectUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int DEFAULT_BYTE_ARRAY_LENGTH = 32;
    private static final Charset DEFAULT_CHARSET = CharsetUtils.defaultCharset();

    public static File zip(String srcPath) throws UtilException {
        return ZipUtils.zip(srcPath, DEFAULT_CHARSET);
    }

    public static File zip(String srcPath, Charset charset) throws UtilException {
        return ZipUtils.zip(FileUtils.file(srcPath), charset);
    }

    public static File zip(File srcFile) throws UtilException {
        return ZipUtils.zip(srcFile, DEFAULT_CHARSET);
    }

    public static File zip(File srcFile, Charset charset) throws UtilException {
        File zipFile = FileUtils.file(srcFile.getParentFile(), FileUtils.mainName(srcFile) + ".zip");
        ZipUtils.zip(zipFile, charset, false, srcFile);
        return zipFile;
    }

    public static File zip(String srcPath, String zipPath) throws UtilException {
        return ZipUtils.zip(srcPath, zipPath, false);
    }

    public static File zip(String srcPath, String zipPath, boolean withSrcDir) throws UtilException {
        return ZipUtils.zip(srcPath, zipPath, DEFAULT_CHARSET, withSrcDir);
    }

    public static File zip(String srcPath, String zipPath, Charset charset, boolean withSrcDir) throws UtilException {
        File srcFile = FileUtils.file(srcPath);
        File zipFile = FileUtils.file(zipPath);
        ZipUtils.zip(zipFile, charset, withSrcDir, srcFile);
        return zipFile;
    }

    public static File zip(File zipFile, boolean withSrcDir, File ... srcFiles) throws UtilException {
        return ZipUtils.zip(zipFile, DEFAULT_CHARSET, withSrcDir, srcFiles);
    }

    public static File zip(File zipFile, Charset charset, boolean withSrcDir, File ... srcFiles) throws UtilException {
        return ZipUtils.zip(zipFile, charset, withSrcDir, null, srcFiles);
    }

    public static File zip(File zipFile, Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws IORuntimeException {
        ZipUtils.validateFiles(zipFile, srcFiles);
        try (ZipOutputStream out = ZipUtils.getZipOutputStream(zipFile, charset);){
            ZipUtils.zip((OutputStream)out, charset, withSrcDir, filter, srcFiles);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return zipFile;
    }

    public static void zip(OutputStream out, Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws IORuntimeException {
        ZipUtils.zip(ZipUtils.getZipOutputStream(out, charset), withSrcDir, filter, srcFiles);
    }

    public static void zip(ZipOutputStream zipOutputStream, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws IORuntimeException {
        try {
            for (File srcFile : srcFiles) {
                if (null == srcFile) continue;
                String srcRootDir = srcFile.getCanonicalPath();
                if (srcFile.isFile() || withSrcDir) {
                    srcRootDir = srcFile.getCanonicalFile().getParentFile().getCanonicalPath();
                }
                ZipUtils.zip(srcFile, srcRootDir, zipOutputStream, filter);
                zipOutputStream.flush();
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File zip(File zipFile, String path, String data) throws UtilException {
        return ZipUtils.zip(zipFile, path, data, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, String data, Charset charset) throws UtilException {
        return ZipUtils.zip(zipFile, path, IOUtils.toStream(data, charset), charset);
    }

    public static File zip(File zipFile, String path, InputStream in) throws UtilException {
        return ZipUtils.zip(zipFile, path, in, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, InputStream in, Charset charset) throws UtilException {
        return ZipUtils.zip(zipFile, new String[]{path}, new InputStream[]{in}, charset);
    }

    public static File zip(File zipFile, String[] paths, InputStream[] ins) throws UtilException {
        return ZipUtils.zip(zipFile, paths, ins, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(File zipFile, String[] paths, InputStream[] ins, Charset charset) throws UtilException {
        if (ArrayUtils.isEmpty(paths) || ArrayUtils.isEmpty(ins)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (paths.length != ins.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        ZipOutputStream out = null;
        try {
            out = ZipUtils.getZipOutputStream(zipFile, charset);
            for (int i = 0; i < paths.length; ++i) {
                ZipUtils.addFile(ins[i], paths[i], out);
            }
        }
        finally {
            IOUtils.closeQuietly(out);
        }
        return zipFile;
    }

    public static File unzip(String zipFilePath) throws UtilException {
        return ZipUtils.unzip(zipFilePath, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, Charset charset) throws UtilException {
        return ZipUtils.unzip(FileUtils.file(zipFilePath), charset);
    }

    public static File unzip(File zipFile) throws UtilException {
        return ZipUtils.unzip(zipFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, Charset charset) throws UtilException {
        File destDir = FileUtils.file(zipFile.getParentFile(), FileUtils.mainName(zipFile));
        return ZipUtils.unzip(zipFile, destDir, charset);
    }

    public static File unzip(String zipFilePath, String outFileDir) throws UtilException {
        return ZipUtils.unzip(zipFilePath, outFileDir, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, String outFileDir, Charset charset) throws UtilException {
        return ZipUtils.unzip(FileUtils.file(zipFilePath), FileUtils.mkdir(outFileDir), charset);
    }

    public static File unzip(File zipFile, File outFile) throws UtilException {
        return ZipUtils.unzip(zipFile, outFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, File outFile, Charset charset) throws UtilException {
        ZipFile zip;
        try {
            zip = new ZipFile(zipFile, charset);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return ZipUtils.unzip(zip, outFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(ZipFile zipFile, File outFile) throws IORuntimeException {
        if (outFile.exists() && outFile.isFile()) {
            throw new UtilException("Target path [{}] exist!", outFile.getAbsolutePath());
        }
        try {
            Enumeration<? extends ZipEntry> em = zipFile.entries();
            while (em.hasMoreElements()) {
                ZipEntry zipEntry = em.nextElement();
                File outItemFile = ZipUtils.buildFile(outFile, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                    continue;
                }
                ZipUtils.write(zipFile, zipEntry, outItemFile);
            }
        }
        finally {
            IOUtils.closeQuietly(zipFile);
        }
        return outFile;
    }

    public static File unzip(InputStream in, File outFile, Charset charset) throws UtilException {
        if (null == charset) {
            charset = DEFAULT_CHARSET;
        }
        return ZipUtils.unzip(new ZipInputStream(in, charset), outFile);
    }

    public static File unzip(ZipInputStream zipStream, File outFile) throws UtilException {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = zipStream.getNextEntry())) {
                File outItemFile = FileUtils.file(outFile, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                    continue;
                }
                FileUtils.writeFromStream((InputStream)zipStream, outItemFile);
            }
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            IOUtils.closeQuietly(zipStream);
        }
        return outFile;
    }

    public static byte[] unzipFileBytes(String zipFilePath, String name) {
        return ZipUtils.unzipFileBytes(zipFilePath, DEFAULT_CHARSET, name);
    }

    public static byte[] unzipFileBytes(String zipFilePath, Charset charset, String name) {
        return ZipUtils.unzipFileBytes(FileUtils.file(zipFilePath), charset, name);
    }

    public static byte[] unzipFileBytes(File zipFile, String name) {
        return ZipUtils.unzipFileBytes(zipFile, DEFAULT_CHARSET, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzipFileBytes(File zipFile, Charset charset, String name) {
        ZipFile zipFileObj;
        block6: {
            byte[] byArray;
            block5: {
                zipFileObj = null;
                try {
                    zipFileObj = new ZipFile(zipFile, charset);
                    Enumeration<? extends ZipEntry> em = zipFileObj.entries();
                    while (em.hasMoreElements()) {
                        ZipEntry zipEntry = em.nextElement();
                        if (zipEntry.isDirectory() || !name.equals(zipEntry.getName())) continue;
                        byArray = IOUtils.readBytes(zipFileObj.getInputStream(zipEntry));
                        break block5;
                    }
                    break block6;
                }
                catch (IOException e) {
                    try {
                        throw new UtilException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(zipFileObj);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly(zipFileObj);
            return byArray;
        }
        IOUtils.closeQuietly(zipFileObj);
        return null;
    }

    public static byte[] gzip(String content, String charset) throws UtilException {
        return ZipUtils.gzip(StringUtils.bytes((CharSequence)content, charset));
    }

    public static byte[] gzip(byte[] buf) throws UtilException {
        return ZipUtils.gzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] gzip(File file) throws UtilException {
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream(file);
            byte[] byArray = ZipUtils.gzip(in, (int)file.length());
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static byte[] gzip(InputStream in) throws UtilException {
        return ZipUtils.gzip(in, 32);
    }

    public static byte[] gzip(InputStream in, int length) throws UtilException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            IOUtils.copy(in, gos);
        }
        catch (IOException e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(gos);
        return bos.toByteArray();
    }

    public static String unGzip(byte[] buf, String charset) throws UtilException {
        return StringUtils.str(ZipUtils.unGzip(buf), charset);
    }

    public static byte[] unGzip(byte[] buf) throws UtilException {
        return ZipUtils.unGzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unGzip(InputStream in) throws UtilException {
        return ZipUtils.unGzip(in, 32);
    }

    public static byte[] unGzip(InputStream in, int length) throws UtilException {
        FastByteArrayOutputStream bos;
        GZIPInputStream gzi = null;
        try {
            gzi = in instanceof GZIPInputStream ? (GZIPInputStream)in : new GZIPInputStream(in);
            bos = new FastByteArrayOutputStream(length);
            IOUtils.copy(gzi, bos);
        }
        catch (IOException e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gzi);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(gzi);
        return bos.toByteArray();
    }

    public static byte[] zlib(String content, String charset, int level) {
        return ZipUtils.zlib(StringUtils.bytes((CharSequence)content, charset), level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zlib(File file, int level) {
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream(file);
            byte[] byArray = ZipUtils.zlib(in, level, (int)file.length());
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static byte[] zlib(byte[] buf, int level) {
        return ZipUtils.zlib(new ByteArrayInputStream(buf), level, buf.length);
    }

    public static byte[] zlib(InputStream in, int level) {
        return ZipUtils.zlib(in, level, 32);
    }

    public static byte[] zlib(InputStream in, int level, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        ZipUtils.deflater(in, out, level, false);
        return out.toByteArray();
    }

    public static String unZlib(byte[] buf, String charset) {
        return StringUtils.str(ZipUtils.unZlib(buf), charset);
    }

    public static byte[] unZlib(byte[] buf) {
        return ZipUtils.unZlib(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unZlib(InputStream in) {
        return ZipUtils.unZlib(in, 32);
    }

    public static byte[] unZlib(InputStream in, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        ZipUtils.inflater(in, out, false);
        return out.toByteArray();
    }

    public static List<String> listFileNames(ZipFile zipFile, String dir) {
        if (StringUtils.isNotBlank(dir)) {
            dir = StringUtils.addSuffixIfNot(dir, "/");
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            String nameSuffix;
            String name = zipEntry.getName();
            if (!StringUtils.isEmpty(dir) && !name.startsWith(dir) || !StringUtils.isNotEmpty(nameSuffix = StringUtils.removePrefix(name, dir)) || StringUtils.contains((CharSequence)nameSuffix, '/')) continue;
            fileNames.add(nameSuffix);
        }
        return fileNames;
    }

    private static ZipOutputStream getZipOutputStream(File zipFile, Charset charset) {
        return ZipUtils.getZipOutputStream(FileUtils.getOutputStream(zipFile), charset);
    }

    private static ZipOutputStream getZipOutputStream(OutputStream out, Charset charset) {
        if (out instanceof ZipOutputStream) {
            return (ZipOutputStream)out;
        }
        return new ZipOutputStream(out, ObjectUtils.defaultIfNull(charset, DEFAULT_CHARSET));
    }

    private static void zip(File file, String srcRootDir, ZipOutputStream out, FileFilter filter) throws UtilException {
        if (null == file || null != filter && !filter.accept(file)) {
            return;
        }
        String subPath = FileUtils.subPath(srcRootDir, file);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (ArrayUtils.isEmpty(files) && StringUtils.isNotEmpty(subPath)) {
                ZipUtils.addDir(subPath, out);
            }
            for (File childFile : files) {
                ZipUtils.zip(childFile, srcRootDir, out, filter);
            }
        } else {
            ZipUtils.addFile(file, subPath, out);
        }
    }

    private static void addFile(File file, String path, ZipOutputStream out) throws UtilException {
        ZipUtils.addFile(FileUtils.getInputStream(file), path, out);
    }

    private static void addFile(InputStream in, String path, ZipOutputStream out) throws UtilException {
        if (null == in) {
            return;
        }
        try {
            out.putNextEntry(new ZipEntry(path));
            IOUtils.copy(in, out);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            IOUtils.closeQuietly(in);
            ZipUtils.closeEntry(out);
        }
    }

    private static void addDir(String path, ZipOutputStream out) throws UtilException {
        path = StringUtils.addSuffixIfNot(path, "/");
        try {
            out.putNextEntry(new ZipEntry(path));
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            ZipUtils.closeEntry(out);
        }
    }

    private static void validateFiles(File zipFile, File ... srcFiles) throws UtilException {
        if (zipFile.isDirectory()) {
            throw new UtilException("Zip file [{}] must not be a directory !", zipFile.getAbsoluteFile());
        }
        for (File srcFile : srcFiles) {
            if (null == srcFile) continue;
            if (!srcFile.exists()) {
                throw new UtilException(StringUtils.format((CharSequence)"File [{}] not exist!", srcFile.getAbsolutePath()));
            }
            try {
                File parentFile = zipFile.getCanonicalFile().getParentFile();
                if (!srcFile.isDirectory() || !parentFile.getCanonicalPath().contains(srcFile.getCanonicalPath())) continue;
                throw new UtilException("Zip file path [{}] must not be the child directory of [{}] !", zipFile.getCanonicalPath(), srcFile.getCanonicalPath());
            }
            catch (IOException e) {
                throw new UtilException(e);
            }
        }
    }

    private static void closeEntry(ZipOutputStream out) {
        try {
            out.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void write(ZipFile zipFile, ZipEntry zipEntry, File outItemFile) throws IORuntimeException {
        InputStream in = null;
        try {
            in = zipFile.getInputStream(zipEntry);
            FileUtils.writeFromStream(in, outItemFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    private static void inflater(InputStream in, OutputStream out, boolean nowrap) {
        InflaterOutputStream ios = out instanceof InflaterOutputStream ? (InflaterOutputStream)out : new InflaterOutputStream(out, new Inflater(nowrap));
        IOUtils.copy(in, ios);
        try {
            ios.finish();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static void deflater(InputStream in, OutputStream out, int level, boolean nowrap) {
        DeflaterOutputStream ios = out instanceof DeflaterOutputStream ? (DeflaterOutputStream)out : new DeflaterOutputStream(out, new Deflater(level, nowrap));
        IOUtils.copy(in, ios);
        try {
            ios.finish();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static File buildFile(File outFile, String fileName) {
        if (!FileUtils.isWindows() && fileName.lastIndexOf(47, fileName.length() - 2) > 0) {
            List<String> pathParts = StringUtils.split(fileName, '/', false, true);
            int lastPartIndex = pathParts.size() - 1;
            for (int i = 0; i < lastPartIndex; ++i) {
                outFile = new File(outFile, pathParts.get(i));
            }
            outFile.mkdirs();
            fileName = pathParts.get(lastPartIndex);
        }
        return FileUtils.file(outFile, fileName);
    }
}

