/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.ctypto;

import com.github.jarvisframework.tool.core.io.FileUtils;
import com.github.jarvisframework.tool.core.io.IOUtils;
import com.github.jarvisframework.tool.core.lang.Assert;
import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.CharsetUtils;
import com.github.jarvisframework.tool.core.util.RandomUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.ctypto.BCUtils;
import com.github.jarvisframework.tool.ctypto.CryptoException;
import com.github.jarvisframework.tool.ctypto.asymmetric.AsymmetricAlgorithmEnum;
import com.github.jarvisframework.tool.ctypto.symmetric.GlobalBouncyCastleProviderEnum;
import com.github.jarvisframework.tool.ctypto.symmetric.SymmetricAlgorithmEnum;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class KeyUtils {
    public static final String KEY_TYPE_JKS = "JKS";
    public static final String KEY_TYPE_JCEKS = "jceks";
    public static final String KEY_TYPE_PKCS12 = "pkcs12";
    public static final String CERT_TYPE_X509 = "X.509";
    public static final int DEFAULT_KEY_SIZE = 1024;
    public static final String SM2_DEFAULT_CURVE = "sm2p256v1";

    public static SecretKey generateKey(String algorithm) {
        return KeyUtils.generateKey(algorithm, -1);
    }

    public static SecretKey generateKey(String algorithm, int keySize) {
        algorithm = KeyUtils.getMainAlgorithm(algorithm);
        KeyGenerator keyGenerator = KeyUtils.getKeyGenerator(algorithm);
        if (keySize > 0) {
            keyGenerator.init(keySize);
        } else if (SymmetricAlgorithmEnum.AES.getValue().equals(algorithm)) {
            keyGenerator.init(128);
        }
        return keyGenerator.generateKey();
    }

    public static SecretKey generateKey(String algorithm, byte[] key) {
        Assert.notBlank((CharSequence)algorithm, (String)"Algorithm is blank!", (Object[])new Object[0]);
        SecretKey secretKey = algorithm.startsWith("PBE") ? KeyUtils.generatePBEKey(algorithm, null == key ? null : StringUtils.str((byte[])key, (Charset)CharsetUtils.CHARSET_UTF_8).toCharArray()) : (algorithm.startsWith("DES") ? KeyUtils.generateDESKey(algorithm, key) : (null == key ? KeyUtils.generateKey(algorithm) : new SecretKeySpec(key, algorithm)));
        return secretKey;
    }

    public static SecretKey generateDESKey(String algorithm, byte[] key) {
        SecretKey secretKey;
        if (StringUtils.isBlank((CharSequence)algorithm) || !algorithm.startsWith("DES")) {
            throw new CryptoException("Algorithm [{}] is not a DES algorithm!");
        }
        if (null == key) {
            secretKey = KeyUtils.generateKey(algorithm);
        } else {
            KeySpec keySpec;
            try {
                keySpec = algorithm.startsWith("DESede") ? new DESedeKeySpec(key) : new DESKeySpec(key);
            }
            catch (InvalidKeyException e) {
                throw new CryptoException(e);
            }
            secretKey = KeyUtils.generateKey(algorithm, keySpec);
        }
        return secretKey;
    }

    public static SecretKey generatePBEKey(String algorithm, char[] key) {
        if (StringUtils.isBlank((CharSequence)algorithm) || !algorithm.startsWith("PBE")) {
            throw new CryptoException("Algorithm [{}] is not a PBE algorithm!");
        }
        if (null == key) {
            key = RandomUtils.randomString((int)32).toCharArray();
        }
        PBEKeySpec keySpec = new PBEKeySpec(key);
        return KeyUtils.generateKey(algorithm, keySpec);
    }

    public static SecretKey generateKey(String algorithm, KeySpec keySpec) {
        SecretKeyFactory keyFactory = KeyUtils.getSecretKeyFactory(algorithm);
        try {
            return keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey generateRSAPrivateKey(byte[] key) {
        return KeyUtils.generatePrivateKey(AsymmetricAlgorithmEnum.RSA.getValue(), key);
    }

    public static PrivateKey generatePrivateKey(String algorithm, byte[] key) {
        if (null == key) {
            return null;
        }
        return KeyUtils.generatePrivateKey(algorithm, new PKCS8EncodedKeySpec(key));
    }

    public static PrivateKey generatePrivateKey(String algorithm, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        algorithm = KeyUtils.getAlgorithmAfterWith(algorithm);
        try {
            return KeyUtils.getKeyFactory(algorithm).generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey generatePrivateKey(KeyStore keyStore, String alias, char[] password) {
        try {
            return (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static PublicKey generateRSAPublicKey(byte[] key) {
        return KeyUtils.generatePublicKey(AsymmetricAlgorithmEnum.RSA.getValue(), key);
    }

    public static PublicKey generatePublicKey(String algorithm, byte[] key) {
        if (null == key) {
            return null;
        }
        return KeyUtils.generatePublicKey(algorithm, new X509EncodedKeySpec(key));
    }

    public static PublicKey generatePublicKey(String algorithm, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        algorithm = KeyUtils.getAlgorithmAfterWith(algorithm);
        try {
            return KeyUtils.getKeyFactory(algorithm).generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static KeyPair generateKeyPair(String algorithm) {
        return KeyUtils.generateKeyPair(algorithm, 1024);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        return KeyUtils.generateKeyPair(algorithm, keySize, null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed) {
        if ("SM2".equalsIgnoreCase(algorithm)) {
            ECGenParameterSpec sm2p256v1 = new ECGenParameterSpec(SM2_DEFAULT_CURVE);
            return KeyUtils.generateKeyPair(algorithm, keySize, seed, sm2p256v1);
        }
        return KeyUtils.generateKeyPair(algorithm, keySize, seed, (AlgorithmParameterSpec[])null);
    }

    public static KeyPair generateKeyPair(String algorithm, AlgorithmParameterSpec params) {
        return KeyUtils.generateKeyPair(algorithm, null, params);
    }

    public static KeyPair generateKeyPair(String algorithm, byte[] seed, AlgorithmParameterSpec param) {
        return KeyUtils.generateKeyPair(algorithm, 1024, seed, param);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed, AlgorithmParameterSpec ... params) {
        return KeyUtils.generateKeyPair(algorithm, keySize, RandomUtils.createSecureRandom((byte[])seed), params);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, SecureRandom random, AlgorithmParameterSpec ... params) {
        algorithm = KeyUtils.getAlgorithmAfterWith(algorithm);
        KeyPairGenerator keyPairGen = KeyUtils.getKeyPairGenerator(algorithm);
        if (keySize > 0) {
            if ("EC".equalsIgnoreCase(algorithm) && keySize > 256) {
                keySize = 256;
            }
            if (null != random) {
                keyPairGen.initialize(keySize, random);
            } else {
                keyPairGen.initialize(keySize);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])params)) {
            for (AlgorithmParameterSpec param : params) {
                if (null == param) continue;
                try {
                    if (null != random) {
                        keyPairGen.initialize(param, random);
                        continue;
                    }
                    keyPairGen.initialize(param);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new CryptoException(e);
                }
            }
        }
        return keyPairGen.generateKeyPair();
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) {
        KeyPairGenerator keyPairGen;
        Provider provider = GlobalBouncyCastleProviderEnum.INSTANCE.getProvider();
        try {
            keyPairGen = null == provider ? KeyPairGenerator.getInstance(KeyUtils.getMainAlgorithm(algorithm)) : KeyPairGenerator.getInstance(KeyUtils.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return keyPairGen;
    }

    public static KeyFactory getKeyFactory(String algorithm) {
        KeyFactory keyFactory;
        Provider provider = GlobalBouncyCastleProviderEnum.INSTANCE.getProvider();
        try {
            keyFactory = null == provider ? KeyFactory.getInstance(KeyUtils.getMainAlgorithm(algorithm)) : KeyFactory.getInstance(KeyUtils.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return keyFactory;
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm) {
        SecretKeyFactory keyFactory;
        Provider provider = GlobalBouncyCastleProviderEnum.INSTANCE.getProvider();
        try {
            keyFactory = null == provider ? SecretKeyFactory.getInstance(KeyUtils.getMainAlgorithm(algorithm)) : SecretKeyFactory.getInstance(KeyUtils.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return keyFactory;
    }

    public static KeyGenerator getKeyGenerator(String algorithm) {
        KeyGenerator generator;
        Provider provider = GlobalBouncyCastleProviderEnum.INSTANCE.getProvider();
        try {
            generator = null == provider ? KeyGenerator.getInstance(KeyUtils.getMainAlgorithm(algorithm)) : KeyGenerator.getInstance(KeyUtils.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return generator;
    }

    public static String getMainAlgorithm(String algorithm) {
        int slashIndex = algorithm.indexOf(47);
        if (slashIndex > 0) {
            return algorithm.substring(0, slashIndex);
        }
        return algorithm;
    }

    public static String getAlgorithmAfterWith(String algorithm) {
        Assert.notNull((Object)algorithm, (String)"algorithm must be not null !", (Object[])new Object[0]);
        int indexOfWith = StringUtils.lastIndexOfIgnoreCase((CharSequence)algorithm, (CharSequence)"with");
        if (indexOfWith > 0) {
            algorithm = StringUtils.subSuf((CharSequence)algorithm, (int)(indexOfWith + "with".length()));
        }
        if ("ECDSA".equalsIgnoreCase(algorithm) || "SM2".equalsIgnoreCase(algorithm)) {
            algorithm = "EC";
        }
        return algorithm;
    }

    public static KeyStore readJKSKeyStore(File keyFile, char[] password) {
        return KeyUtils.readKeyStore(KEY_TYPE_JKS, keyFile, password);
    }

    public static KeyStore readJKSKeyStore(InputStream in, char[] password) {
        return KeyUtils.readKeyStore(KEY_TYPE_JKS, in, password);
    }

    public static KeyStore readPKCS12KeyStore(File keyFile, char[] password) {
        return KeyUtils.readKeyStore(KEY_TYPE_PKCS12, keyFile, password);
    }

    public static KeyStore readPKCS12KeyStore(InputStream in, char[] password) {
        return KeyUtils.readKeyStore(KEY_TYPE_PKCS12, in, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore readKeyStore(String type, File keyFile, char[] password) {
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream((File)keyFile);
            KeyStore keyStore = KeyUtils.readKeyStore(type, in, password);
            return keyStore;
        }
        finally {
            IOUtils.closeQuietly((Closeable)in);
        }
    }

    public static KeyStore readKeyStore(String type, InputStream in, char[] password) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(type);
            keyStore.load(in, password);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return keyStore;
    }

    public static KeyPair getKeyPair(String type, InputStream in, char[] password, String alias) {
        KeyStore keyStore = KeyUtils.readKeyStore(type, in, password);
        return KeyUtils.getKeyPair(keyStore, password, alias);
    }

    public static KeyPair getKeyPair(KeyStore keyStore, char[] password, String alias) {
        PrivateKey privateKey;
        PublicKey publicKey;
        try {
            publicKey = keyStore.getCertificate(alias).getPublicKey();
            privateKey = (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return new KeyPair(publicKey, privateKey);
    }

    public static Certificate readX509Certificate(InputStream in, char[] password, String alias) {
        return KeyUtils.readCertificate(CERT_TYPE_X509, in, password, alias);
    }

    public static PublicKey readPublicKeyFromCert(InputStream in) {
        Certificate certificate = KeyUtils.readX509Certificate(in);
        if (null != certificate) {
            return certificate.getPublicKey();
        }
        return null;
    }

    public static Certificate readX509Certificate(InputStream in) {
        return KeyUtils.readCertificate(CERT_TYPE_X509, in);
    }

    public static Certificate readCertificate(String type, InputStream in, char[] password, String alias) {
        KeyStore keyStore = KeyUtils.readKeyStore(type, in, password);
        try {
            return keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e);
        }
    }

    public static Certificate readCertificate(String type, InputStream in) {
        try {
            return KeyUtils.getCertificateFactory(type).generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new CryptoException(e);
        }
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        try {
            return keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static CertificateFactory getCertificateFactory(String type) {
        CertificateFactory factory;
        Provider provider = GlobalBouncyCastleProviderEnum.INSTANCE.getProvider();
        try {
            factory = null == provider ? CertificateFactory.getInstance(type) : CertificateFactory.getInstance(type, provider);
        }
        catch (CertificateException e) {
            throw new CryptoException(e);
        }
        return factory;
    }

    public static byte[] encodeECPublicKey(PublicKey publicKey) {
        return BCUtils.encodeECPublicKey(publicKey);
    }

    public static PublicKey decodeECPoint(String encode, String curveName) {
        return BCUtils.decodeECPoint(encode, curveName);
    }

    public static PublicKey decodeECPoint(byte[] encodeByte, String curveName) {
        return BCUtils.decodeECPoint(encodeByte, curveName);
    }

    public static PublicKey getRSAPublicKey(PrivateKey privateKey) {
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey privk = (RSAPrivateCrtKey)privateKey;
            return KeyUtils.getRSAPublicKey(privk.getModulus(), privk.getPublicExponent());
        }
        return null;
    }

    public static PublicKey getRSAPublicKey(String modulus, String publicExponent) {
        return KeyUtils.getRSAPublicKey(new BigInteger(modulus, 16), new BigInteger(publicExponent, 16));
    }

    public static PublicKey getRSAPublicKey(BigInteger modulus, BigInteger publicExponent) {
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
        try {
            return KeyUtils.getKeyFactory("RSA").generatePublic(publicKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoException(e);
        }
    }
}

