/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.ctypto;

import com.github.jarvisframework.tool.core.io.IORuntimeException;
import com.github.jarvisframework.tool.core.io.IOUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.ctypto.KeyUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

public class PemUtils {
    public static PrivateKey readPemPrivateKey(InputStream pemStream) {
        return (PrivateKey)PemUtils.readPemKey(pemStream);
    }

    public static PublicKey readPemPublicKey(InputStream pemStream) {
        return (PublicKey)PemUtils.readPemKey(pemStream);
    }

    public static Key readPemKey(InputStream keyStream) {
        PemObject object = PemUtils.readPemObject(keyStream);
        String type = object.getType();
        if (StringUtils.isNotBlank((CharSequence)type)) {
            if (type.endsWith("PRIVATE KEY")) {
                return KeyUtils.generateRSAPrivateKey(object.getContent());
            }
            if (type.endsWith("PUBLIC KEY")) {
                return KeyUtils.generateRSAPublicKey(object.getContent());
            }
            if (type.endsWith("CERTIFICATE")) {
                return KeyUtils.readPublicKeyFromCert(IOUtils.toStream((byte[])object.getContent()));
            }
        }
        return null;
    }

    public static byte[] readPem(InputStream keyStream) {
        PemObject pemObject = PemUtils.readPemObject(keyStream);
        if (null != pemObject) {
            return pemObject.getContent();
        }
        return null;
    }

    public static PemObject readPemObject(InputStream keyStream) {
        return PemUtils.readPemObject(IOUtils.getUtf8Reader((InputStream)keyStream));
    }

    public static PemObject readPemObject(Reader reader) {
        PemObject pemObject;
        PemReader pemReader = null;
        try {
            pemReader = new PemReader(reader);
            pemObject = pemReader.readPemObject();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pemReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)pemReader);
        return pemObject;
    }

    public static void writePemObject(String type, byte[] content, OutputStream keyStream) {
        PemUtils.writePemObject((PemObjectGenerator)new PemObject(type, content), keyStream);
    }

    public static void writePemObject(PemObjectGenerator pemObject, OutputStream keyStream) {
        PemWriter writer = null;
        try {
            writer = new PemWriter((Writer)IOUtils.getUtf8Writer((OutputStream)keyStream));
            writer.writeObject(pemObject);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)writer);
    }
}

