/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.ctypto.asymmetric;

import com.github.jarvisframework.tool.core.codec.Base64;
import com.github.jarvisframework.tool.core.io.FastByteArrayOutputStream;
import com.github.jarvisframework.tool.ctypto.CryptoException;
import com.github.jarvisframework.tool.ctypto.SecureUtils;
import com.github.jarvisframework.tool.ctypto.asymmetric.AbstractAsymmetricCrypto;
import com.github.jarvisframework.tool.ctypto.asymmetric.AsymmetricAlgorithmEnum;
import com.github.jarvisframework.tool.ctypto.asymmetric.KeyTypeEnum;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class AsymmetricCrypto
extends AbstractAsymmetricCrypto<AsymmetricCrypto> {
    protected Cipher cipher;
    protected int encryptBlockSize = -1;
    protected int decryptBlockSize = -1;

    public AsymmetricCrypto(AsymmetricAlgorithmEnum algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(String algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(AsymmetricAlgorithmEnum algorithm, String privateKeyStr, String publicKeyStr) {
        this(algorithm.getValue(), SecureUtils.decode(privateKeyStr), SecureUtils.decode(publicKeyStr));
    }

    public AsymmetricCrypto(AsymmetricAlgorithmEnum algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public AsymmetricCrypto(AsymmetricAlgorithmEnum algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public AsymmetricCrypto(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        this(algorithm, Base64.decode((CharSequence)privateKeyBase64), Base64.decode((CharSequence)publicKeyBase64));
    }

    public AsymmetricCrypto(String algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm, SecureUtils.generatePrivateKey(algorithm, privateKey), SecureUtils.generatePublicKey(algorithm, publicKey));
    }

    public AsymmetricCrypto(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public int getEncryptBlockSize() {
        return this.encryptBlockSize;
    }

    public void setEncryptBlockSize(int encryptBlockSize) {
        this.encryptBlockSize = encryptBlockSize;
    }

    public int getDecryptBlockSize() {
        return this.decryptBlockSize;
    }

    public void setDecryptBlockSize(int decryptBlockSize) {
        this.decryptBlockSize = decryptBlockSize;
    }

    @Override
    public AsymmetricCrypto init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super.init(algorithm, privateKey, publicKey);
        this.initCipher();
        return this;
    }

    @Override
    public byte[] encrypt(byte[] data, KeyTypeEnum keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            int blockSize22;
            this.cipher.init(1, key);
            if (this.encryptBlockSize < 0 && (blockSize22 = this.cipher.getBlockSize()) > 0) {
                this.encryptBlockSize = blockSize22;
            }
            byte[] blockSize22 = this.doFinal(data, this.encryptBlockSize < 0 ? data.length : this.encryptBlockSize);
            return blockSize22;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] decrypt(byte[] data, KeyTypeEnum keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            int blockSize22;
            this.cipher.init(2, key);
            if (this.decryptBlockSize < 0 && (blockSize22 = this.cipher.getBlockSize()) > 0) {
                this.decryptBlockSize = blockSize22;
            }
            byte[] blockSize22 = this.doFinal(data, this.decryptBlockSize < 0 ? data.length : this.decryptBlockSize);
            return blockSize22;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Cipher getClipher() {
        return this.cipher;
    }

    protected void initCipher() {
        this.cipher = SecureUtils.createCipher(this.algorithm);
    }

    private byte[] doFinal(byte[] data, int maxBlockSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        int dataLength = data.length;
        if (dataLength <= maxBlockSize) {
            return this.cipher.doFinal(data, 0, dataLength);
        }
        return this.doFinalWithBlock(data, maxBlockSize);
    }

    private byte[] doFinalWithBlock(byte[] data, int maxBlockSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        int dataLength = data.length;
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        int offSet = 0;
        int remainLength = dataLength;
        while (remainLength > 0) {
            int blockSize = Math.min(remainLength, maxBlockSize);
            out.write(this.cipher.doFinal(data, offSet, blockSize));
            remainLength = dataLength - (offSet += blockSize);
        }
        return out.toByteArray();
    }
}

