/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.ctypto.symmetric;

import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.ctypto.ModeEnum;
import com.github.jarvisframework.tool.ctypto.PaddingEnum;
import com.github.jarvisframework.tool.ctypto.SecureUtils;
import com.github.jarvisframework.tool.ctypto.symmetric.SymmetricAlgorithmEnum;
import com.github.jarvisframework.tool.ctypto.symmetric.SymmetricCrypto;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class AES
extends SymmetricCrypto {
    private static final long serialVersionUID = 1L;

    public AES() {
        super(SymmetricAlgorithmEnum.AES);
    }

    public AES(byte[] key) {
        super(SymmetricAlgorithmEnum.AES, key);
    }

    public AES(ModeEnum mode, PaddingEnum padding) {
        this(mode.name(), padding.name());
    }

    public AES(ModeEnum mode, PaddingEnum padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public AES(ModeEnum mode, PaddingEnum padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public AES(ModeEnum mode, PaddingEnum padding, SecretKey key) {
        this(mode, padding, key, (IvParameterSpec)null);
    }

    public AES(ModeEnum mode, PaddingEnum padding, SecretKey key, byte[] iv) {
        this(mode, padding, key, ArrayUtils.isEmpty((byte[])iv) ? null : new IvParameterSpec(iv));
    }

    public AES(ModeEnum mode, PaddingEnum padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public AES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public AES(String mode, String padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public AES(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, SecureUtils.generateKey(SymmetricAlgorithmEnum.AES.getValue(), key), ArrayUtils.isEmpty((byte[])iv) ? null : new IvParameterSpec(iv));
    }

    public AES(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public AES(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StringUtils.format((CharSequence)"AES/{}/{}", (Object[])new Object[]{mode, padding}), key, iv);
    }
}

