/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.ctypto.asymmetric;

import com.github.jarvisframework.tool.core.codec.BCD;
import com.github.jarvisframework.tool.core.codec.Base64;
import com.github.jarvisframework.tool.core.io.IORuntimeException;
import com.github.jarvisframework.tool.core.io.IOUtils;
import com.github.jarvisframework.tool.core.util.CharsetUtils;
import com.github.jarvisframework.tool.core.util.HexUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.ctypto.SecureUtils;
import com.github.jarvisframework.tool.ctypto.asymmetric.BaseAsymmetric;
import com.github.jarvisframework.tool.ctypto.asymmetric.KeyTypeEnum;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.PublicKey;

public abstract class AbstractAsymmetricCrypto<T extends AbstractAsymmetricCrypto<T>>
extends BaseAsymmetric<T> {
    public AbstractAsymmetricCrypto(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public abstract byte[] encrypt(byte[] var1, KeyTypeEnum var2);

    public String encryptHex(byte[] data, KeyTypeEnum keyType) {
        return HexUtils.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    public String encryptBase64(byte[] data, KeyTypeEnum keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    public byte[] encrypt(String data, String charset, KeyTypeEnum keyType) {
        return this.encrypt(StringUtils.bytes((CharSequence)data, (String)charset), keyType);
    }

    public byte[] encrypt(String data, Charset charset, KeyTypeEnum keyType) {
        return this.encrypt(StringUtils.bytes((CharSequence)data, (Charset)charset), keyType);
    }

    public byte[] encrypt(String data, KeyTypeEnum keyType) {
        return this.encrypt(StringUtils.bytes((CharSequence)data, (Charset)CharsetUtils.CHARSET_UTF_8), keyType);
    }

    public String encryptHex(String data, KeyTypeEnum keyType) {
        return HexUtils.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    public String encryptHex(String data, Charset charset, KeyTypeEnum keyType) {
        return HexUtils.encodeHexStr((byte[])this.encrypt(data, charset, keyType));
    }

    public String encryptBase64(String data, KeyTypeEnum keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    public String encryptBase64(String data, Charset charset, KeyTypeEnum keyType) {
        return Base64.encode((byte[])this.encrypt(data, charset, keyType));
    }

    public byte[] encrypt(InputStream data, KeyTypeEnum keyType) throws IORuntimeException {
        return this.encrypt(IOUtils.readBytes((InputStream)data), keyType);
    }

    public String encryptHex(InputStream data, KeyTypeEnum keyType) {
        return HexUtils.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    public String encryptBase64(InputStream data, KeyTypeEnum keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    public String encryptBcd(String data, KeyTypeEnum keyType) {
        return this.encryptBcd(data, keyType, CharsetUtils.CHARSET_UTF_8);
    }

    public String encryptBcd(String data, KeyTypeEnum keyType, Charset charset) {
        return BCD.bcdToStr((byte[])this.encrypt(data, charset, keyType));
    }

    public abstract byte[] decrypt(byte[] var1, KeyTypeEnum var2);

    public byte[] decrypt(InputStream data, KeyTypeEnum keyType) throws IORuntimeException {
        return this.decrypt(IOUtils.readBytes((InputStream)data), keyType);
    }

    public byte[] decrypt(String data, KeyTypeEnum keyType) {
        return this.decrypt(SecureUtils.decode(data), keyType);
    }

    public String decryptStr(String data, KeyTypeEnum keyType, Charset charset) {
        return StringUtils.str((byte[])this.decrypt(data, keyType), (Charset)charset);
    }

    public String decryptStr(String data, KeyTypeEnum keyType) {
        return this.decryptStr(data, keyType, CharsetUtils.CHARSET_UTF_8);
    }

    public byte[] decryptFromBcd(String data, KeyTypeEnum keyType) {
        return this.decryptFromBcd(data, keyType, CharsetUtils.CHARSET_UTF_8);
    }

    public byte[] decryptFromBcd(String data, KeyTypeEnum keyType, Charset charset) {
        byte[] dataBytes = BCD.ascToBcd((byte[])StringUtils.bytes((CharSequence)data, (Charset)charset));
        return this.decrypt(dataBytes, keyType);
    }

    public String decryptStrFromBcd(String data, KeyTypeEnum keyType, Charset charset) {
        return StringUtils.str((byte[])this.decryptFromBcd(data, keyType, charset), (Charset)charset);
    }

    public String decryptStrFromBcd(String data, KeyTypeEnum keyType) {
        return this.decryptStrFromBcd(data, keyType, CharsetUtils.CHARSET_UTF_8);
    }
}

