/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.ctypto.asymmetric;

import com.github.jarvisframework.tool.core.util.CharsetUtils;
import com.github.jarvisframework.tool.ctypto.CryptoException;
import com.github.jarvisframework.tool.ctypto.SecureUtils;
import com.github.jarvisframework.tool.ctypto.asymmetric.AsymmetricAlgorithmEnum;
import com.github.jarvisframework.tool.ctypto.asymmetric.AsymmetricCrypto;
import com.github.jarvisframework.tool.ctypto.asymmetric.KeyTypeEnum;
import com.github.jarvisframework.tool.ctypto.symmetric.GlobalBouncyCastleProviderEnum;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class RSA
extends AsymmetricCrypto {
    private static final AsymmetricAlgorithmEnum ALGORITHM_RSA = AsymmetricAlgorithmEnum.RSA_ECB_PKCS1;

    public static PrivateKey generatePrivateKey(BigInteger modulus, BigInteger privateExponent) {
        return SecureUtils.generatePrivateKey(ALGORITHM_RSA.getValue(), new RSAPrivateKeySpec(modulus, privateExponent));
    }

    public static PublicKey generatePublicKey(BigInteger modulus, BigInteger publicExponent) {
        return SecureUtils.generatePublicKey(ALGORITHM_RSA.getValue(), new RSAPublicKeySpec(modulus, publicExponent));
    }

    public RSA() {
        super(ALGORITHM_RSA);
    }

    public RSA(String rsaAlgorithm) {
        super(rsaAlgorithm);
    }

    public RSA(String privateKeyStr, String publicKeyStr) {
        super(ALGORITHM_RSA, privateKeyStr, publicKeyStr);
    }

    public RSA(String rsaAlgorithm, String privateKeyStr, String publicKeyStr) {
        super(rsaAlgorithm, privateKeyStr, publicKeyStr);
    }

    public RSA(byte[] privateKey, byte[] publicKey) {
        super(ALGORITHM_RSA, privateKey, publicKey);
    }

    public RSA(BigInteger modulus, BigInteger privateExponent, BigInteger publicExponent) {
        this(RSA.generatePrivateKey(modulus, privateExponent), RSA.generatePublicKey(modulus, publicExponent));
    }

    public RSA(PrivateKey privateKey, PublicKey publicKey) {
        super(ALGORITHM_RSA, privateKey, publicKey);
    }

    public RSA(String rsaAlgorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(rsaAlgorithm, privateKey, publicKey);
    }

    @Deprecated
    public String encryptStr(String data, KeyTypeEnum keyType) {
        return this.encryptBcd(data, keyType, CharsetUtils.CHARSET_UTF_8);
    }

    @Deprecated
    public String encryptStr(String data, KeyTypeEnum keyType, Charset charset) {
        return this.encryptBcd(data, keyType, charset);
    }

    @Override
    public byte[] encrypt(byte[] data, KeyTypeEnum keyType) {
        if (this.encryptBlockSize < 0 && null == GlobalBouncyCastleProviderEnum.INSTANCE.getProvider()) {
            this.encryptBlockSize = ((RSAKey)((Object)this.getKeyByType(keyType))).getModulus().bitLength() / 8 - 11;
        }
        return super.encrypt(data, keyType);
    }

    @Override
    public byte[] decrypt(byte[] bytes, KeyTypeEnum keyType) {
        if (this.decryptBlockSize < 0 && null == GlobalBouncyCastleProviderEnum.INSTANCE.getProvider()) {
            this.decryptBlockSize = ((RSAKey)((Object)this.getKeyByType(keyType))).getModulus().bitLength() / 8;
        }
        return super.decrypt(bytes, keyType);
    }

    @Override
    protected void initCipher() {
        try {
            super.initCipher();
        }
        catch (CryptoException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                this.algorithm = AsymmetricAlgorithmEnum.RSA.getValue();
                super.initCipher();
            }
            throw e;
        }
    }
}

