/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.ctypto.digest;

import com.github.jarvisframework.tool.core.util.CharsetUtils;
import com.github.jarvisframework.tool.ctypto.digest.BCrypt;
import com.github.jarvisframework.tool.ctypto.digest.DigestAlgorithmEnum;
import com.github.jarvisframework.tool.ctypto.digest.Digester;
import com.github.jarvisframework.tool.ctypto.digest.HMac;
import com.github.jarvisframework.tool.ctypto.digest.HmacAlgorithmEnum;
import com.github.jarvisframework.tool.ctypto.digest.MD5;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.Key;
import javax.crypto.SecretKey;

public class DigestUtils {
    public static byte[] md5(byte[] data) {
        return new MD5().digest(data);
    }

    public static byte[] md5(String data, String charset) {
        return new MD5().digest(data, charset);
    }

    public static byte[] md5(String data) {
        return DigestUtils.md5(data, "UTF-8");
    }

    public static byte[] md5(InputStream data) {
        return new MD5().digest(data);
    }

    public static byte[] md5(File file) {
        return new MD5().digest(file);
    }

    public static String md5Hex(byte[] data) {
        return new MD5().digestHex(data);
    }

    public static String md5Hex(String data, String charset) {
        return new MD5().digestHex(data, charset);
    }

    public static String md5Hex(String data, Charset charset) {
        return new MD5().digestHex(data, charset);
    }

    public static String md5Hex(String data) {
        return DigestUtils.md5Hex(data, "UTF-8");
    }

    public static String md5Hex(InputStream data) {
        return new MD5().digestHex(data);
    }

    public static String md5Hex(File file) {
        return new MD5().digestHex(file);
    }

    public static String md5Hex16(byte[] data) {
        return new MD5().digestHex16(data);
    }

    public static String md5Hex16(String data, Charset charset) {
        return new MD5().digestHex16(data, charset);
    }

    public static String md5Hex16(String data) {
        return DigestUtils.md5Hex16(data, CharsetUtils.CHARSET_UTF_8);
    }

    public static String md5Hex16(InputStream data) {
        return new MD5().digestHex16(data);
    }

    public static String md5Hex16(File file) {
        return new MD5().digestHex16(file);
    }

    public static String md5HexTo16(String md5Hex) {
        return md5Hex.substring(8, 24);
    }

    public static byte[] sha1(byte[] data) {
        return new Digester(DigestAlgorithmEnum.SHA1).digest(data);
    }

    public static byte[] sha1(String data, String charset) {
        return new Digester(DigestAlgorithmEnum.SHA1).digest(data, charset);
    }

    public static byte[] sha1(String data) {
        return DigestUtils.sha1(data, "UTF-8");
    }

    public static byte[] sha1(InputStream data) {
        return new Digester(DigestAlgorithmEnum.SHA1).digest(data);
    }

    public static byte[] sha1(File file) {
        return new Digester(DigestAlgorithmEnum.SHA1).digest(file);
    }

    public static String sha1Hex(byte[] data) {
        return new Digester(DigestAlgorithmEnum.SHA1).digestHex(data);
    }

    public static String sha1Hex(String data, String charset) {
        return new Digester(DigestAlgorithmEnum.SHA1).digestHex(data, charset);
    }

    public static String sha1Hex(String data) {
        return DigestUtils.sha1Hex(data, "UTF-8");
    }

    public static String sha1Hex(InputStream data) {
        return new Digester(DigestAlgorithmEnum.SHA1).digestHex(data);
    }

    public static String sha1Hex(File file) {
        return new Digester(DigestAlgorithmEnum.SHA1).digestHex(file);
    }

    public static byte[] sha256(byte[] data) {
        return new Digester(DigestAlgorithmEnum.SHA256).digest(data);
    }

    public static byte[] sha256(String data, String charset) {
        return new Digester(DigestAlgorithmEnum.SHA256).digest(data, charset);
    }

    public static byte[] sha256(String data) {
        return DigestUtils.sha256(data, "UTF-8");
    }

    public static byte[] sha256(InputStream data) {
        return new Digester(DigestAlgorithmEnum.SHA256).digest(data);
    }

    public static byte[] sha256(File file) {
        return new Digester(DigestAlgorithmEnum.SHA256).digest(file);
    }

    public static String sha256Hex(byte[] data) {
        return new Digester(DigestAlgorithmEnum.SHA256).digestHex(data);
    }

    public static String sha256Hex(String data, String charset) {
        return new Digester(DigestAlgorithmEnum.SHA256).digestHex(data, charset);
    }

    public static String sha256Hex(String data) {
        return DigestUtils.sha256Hex(data, "UTF-8");
    }

    public static String sha256Hex(InputStream data) {
        return new Digester(DigestAlgorithmEnum.SHA256).digestHex(data);
    }

    public static String sha256Hex(File file) {
        return new Digester(DigestAlgorithmEnum.SHA256).digestHex(file);
    }

    public static HMac hmac(HmacAlgorithmEnum algorithm, byte[] key) {
        return new HMac(algorithm, key);
    }

    public static HMac hmac(HmacAlgorithmEnum algorithm, SecretKey key) {
        return new HMac(algorithm, (Key)key);
    }

    public static Digester digester(DigestAlgorithmEnum algorithm) {
        return new Digester(algorithm);
    }

    public static Digester digester(String algorithm) {
        return new Digester(algorithm);
    }

    public static String bcrypt(String password) {
        return BCrypt.hashpw(password);
    }

    public static boolean bcryptCheck(String password, String hashed) {
        return BCrypt.checkpw(password, hashed);
    }
}

