/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.ctypto.digest;

import com.github.jarvisframework.tool.core.io.FileUtils;
import com.github.jarvisframework.tool.core.io.IOUtils;
import com.github.jarvisframework.tool.core.util.HexUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.ctypto.CryptoException;
import com.github.jarvisframework.tool.ctypto.digest.HmacAlgorithmEnum;
import com.github.jarvisframework.tool.ctypto.digest.mac.MacEngine;
import com.github.jarvisframework.tool.ctypto.digest.mac.MacEngineFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;

public class HMac
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MacEngine engine;

    public HMac(HmacAlgorithmEnum algorithm) {
        this(algorithm, (Key)null);
    }

    public HMac(HmacAlgorithmEnum algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public HMac(HmacAlgorithmEnum algorithm, Key key) {
        this(algorithm.getValue(), key);
    }

    public HMac(String algorithm, byte[] key) {
        this(algorithm, (Key)new SecretKeySpec(key, algorithm));
    }

    public HMac(String algorithm, Key key) {
        this(MacEngineFactory.createEngine(algorithm, key));
    }

    public HMac(MacEngine engine) {
        this.engine = engine;
    }

    public byte[] digest(String data, String charset) {
        return this.digest(StringUtils.bytes((CharSequence)data, (String)charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, "UTF-8");
    }

    public String digestHex(String data, String charset) {
        return HexUtils.encodeHexStr((byte[])this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) throws CryptoException {
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream((File)file);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)in);
        }
    }

    public String digestHex(File file) {
        return HexUtils.encodeHexStr((byte[])this.digest(file));
    }

    public byte[] digest(byte[] data) {
        return this.digest(new ByteArrayInputStream(data), -1);
    }

    public String digestHex(byte[] data) {
        return HexUtils.encodeHexStr((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 8192);
    }

    public String digestHex(InputStream data) {
        return HexUtils.encodeHexStr((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) {
        return this.engine.digest(data, bufferLength);
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtils.encodeHexStr((byte[])this.digest(data, bufferLength));
    }

    public int getMacLength() {
        return this.engine.getMacLength();
    }

    public String getAlgorithm() {
        return this.engine.getAlgorithm();
    }
}

