/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.ctypto.symmetric;

import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.ctypto.ModeEnum;
import com.github.jarvisframework.tool.ctypto.PaddingEnum;
import com.github.jarvisframework.tool.ctypto.SecureUtils;
import com.github.jarvisframework.tool.ctypto.symmetric.SymmetricAlgorithmEnum;
import com.github.jarvisframework.tool.ctypto.symmetric.SymmetricCrypto;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class DES
extends SymmetricCrypto {
    private static final long serialVersionUID = 1L;

    public DES() {
        super(SymmetricAlgorithmEnum.DES);
    }

    public DES(byte[] key) {
        super(SymmetricAlgorithmEnum.DES, key);
    }

    public DES(ModeEnum mode, PaddingEnum padding) {
        this(mode.name(), padding.name());
    }

    public DES(ModeEnum mode, PaddingEnum padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public DES(ModeEnum mode, PaddingEnum padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(ModeEnum mode, PaddingEnum padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(ModeEnum mode, PaddingEnum padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public DES(String mode, String padding, byte[] key) {
        this(mode, padding, SecureUtils.generateKey("DES", key), null);
    }

    public DES(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, SecureUtils.generateKey("DES", key), null == iv ? null : new IvParameterSpec(iv));
    }

    public DES(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StringUtils.format((CharSequence)"DES/{}/{}", (Object[])new Object[]{mode, padding}), key, iv);
    }
}

