/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.ctypto.symmetric;

import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.ctypto.ModeEnum;
import com.github.jarvisframework.tool.ctypto.PaddingEnum;
import com.github.jarvisframework.tool.ctypto.SecureUtils;
import com.github.jarvisframework.tool.ctypto.symmetric.SymmetricCrypto;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SM4
extends SymmetricCrypto {
    private static final long serialVersionUID = 1L;
    public static final String ALGORITHM_NAME = "SM4";

    public SM4() {
        super(ALGORITHM_NAME);
    }

    public SM4(byte[] key) {
        super(ALGORITHM_NAME, key);
    }

    public SM4(ModeEnum mode, PaddingEnum padding) {
        this(mode.name(), padding.name());
    }

    public SM4(ModeEnum mode, PaddingEnum padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public SM4(ModeEnum mode, PaddingEnum padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public SM4(ModeEnum mode, PaddingEnum padding, SecretKey key) {
        this(mode, padding, key, (IvParameterSpec)null);
    }

    public SM4(ModeEnum mode, PaddingEnum padding, SecretKey key, byte[] iv) {
        this(mode, padding, key, ArrayUtils.isEmpty((byte[])iv) ? (IvParameterSpec)null : new IvParameterSpec(iv));
    }

    public SM4(ModeEnum mode, PaddingEnum padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public SM4(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public SM4(String mode, String padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public SM4(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, SecureUtils.generateKey(ALGORITHM_NAME, key), ArrayUtils.isEmpty((byte[])iv) ? null : new IvParameterSpec(iv));
    }

    public SM4(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public SM4(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StringUtils.format((CharSequence)"SM4/{}/{}", (Object[])new Object[]{mode, padding}), key, iv);
    }
}

