/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.email;

import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.email.MailException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;

public class InternalMailUtils {
    public static InternetAddress[] parseAddressFromStrs(String[] addrStrs, Charset charset) {
        ArrayList resultList = new ArrayList(addrStrs.length);
        for (String addrStr : addrStrs) {
            Object[] addresses = InternalMailUtils.parseAddress(addrStr, charset);
            if (!ArrayUtils.isNotEmpty((Object[])addresses)) continue;
            Collections.addAll(resultList, addresses);
        }
        return resultList.toArray(new InternetAddress[0]);
    }

    public static InternetAddress parseFirstAddress(String address, Charset charset) {
        Object[] internetAddresses = InternalMailUtils.parseAddress(address, charset);
        if (ArrayUtils.isEmpty((Object[])internetAddresses)) {
            try {
                return new InternetAddress(address);
            }
            catch (AddressException e) {
                throw new MailException(e);
            }
        }
        return internetAddresses[0];
    }

    public static InternetAddress[] parseAddress(String address, Charset charset) {
        Object[] addresses;
        try {
            addresses = InternetAddress.parse((String)address);
        }
        catch (AddressException e) {
            throw new MailException(e);
        }
        if (ArrayUtils.isNotEmpty((Object[])addresses)) {
            for (Object internetAddress : addresses) {
                try {
                    internetAddress.setPersonal(internetAddress.getPersonal(), charset.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new MailException(e);
                }
            }
        }
        return addresses;
    }

    public static String encodeText(String text, Charset charset) {
        try {
            return MimeUtility.encodeText((String)text, (String)charset.name(), null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return text;
        }
    }
}

