/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.email;

import com.github.jarvisframework.tool.core.io.FileUtils;
import com.github.jarvisframework.tool.core.io.IORuntimeException;
import com.github.jarvisframework.tool.core.io.IOUtils;
import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.ObjectUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.email.GlobalMailAccountEnum;
import com.github.jarvisframework.tool.email.InternalMailUtils;
import com.github.jarvisframework.tool.email.MailAccount;
import com.github.jarvisframework.tool.email.MailException;
import com.github.jarvisframework.tool.email.UserPassAuthenticator;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public class Mail {
    private final MailAccount mailAccount;
    private String[] tos;
    private String[] ccs;
    private String[] bccs;
    private String[] reply;
    private String title;
    private String content;
    private boolean isHtml;
    private final Multipart multipart = new MimeMultipart();
    private boolean useGlobalSession = false;

    public static Mail create(MailAccount mailAccount) {
        return new Mail(mailAccount);
    }

    public static Mail create() {
        return new Mail();
    }

    public Mail() {
        this(GlobalMailAccountEnum.INSTANCE.getAccount());
    }

    public Mail(MailAccount mailAccount) {
        mailAccount = null != mailAccount ? mailAccount : GlobalMailAccountEnum.INSTANCE.getAccount();
        this.mailAccount = mailAccount.defaultIfEmpty();
    }

    public Mail to(String ... tos) {
        return this.setTos(tos);
    }

    public Mail setTos(String ... tos) {
        this.tos = tos;
        return this;
    }

    public Mail setCcs(String ... ccs) {
        this.ccs = ccs;
        return this;
    }

    public Mail setBccs(String ... bccs) {
        this.bccs = bccs;
        return this;
    }

    public Mail setReply(String ... reply) {
        this.reply = reply;
        return this;
    }

    public Mail setTitle(String title) {
        this.title = title;
        return this;
    }

    public Mail setContent(String content) {
        this.content = content;
        return this;
    }

    public Mail setHtml(boolean isHtml) {
        this.isHtml = isHtml;
        return this;
    }

    public Mail setContent(String content, boolean isHtml) {
        this.setContent(content);
        return this.setHtml(isHtml);
    }

    public Mail setFiles(File ... files) {
        if (ArrayUtils.isEmpty((Object[])files)) {
            return this;
        }
        DataSource[] attachments = new DataSource[files.length];
        for (int i = 0; i < files.length; ++i) {
            attachments[i] = new FileDataSource(files[i]);
        }
        return this.setAttachments(attachments);
    }

    public Mail setAttachments(DataSource ... attachments) {
        if (ArrayUtils.isNotEmpty((Object[])attachments)) {
            Charset charset = this.mailAccount.getCharset();
            try {
                for (DataSource attachment : attachments) {
                    MimeBodyPart bodyPart = new MimeBodyPart();
                    bodyPart.setDataHandler(new DataHandler(attachment));
                    String nameEncoded = InternalMailUtils.encodeText(attachment.getName(), charset);
                    bodyPart.setFileName(nameEncoded);
                    if (StringUtils.startWith((CharSequence)attachment.getContentType(), (CharSequence)"image/")) {
                        bodyPart.setContentID(nameEncoded);
                    }
                    this.multipart.addBodyPart((BodyPart)bodyPart);
                }
            }
            catch (MessagingException e) {
                throw new MailException(e);
            }
        }
        return this;
    }

    public Mail addImage(String cid, InputStream imageStream) {
        return this.addImage(cid, imageStream, null);
    }

    public Mail addImage(String cid, InputStream imageStream, String contentType) {
        ByteArrayDataSource imgSource;
        try {
            imgSource = new ByteArrayDataSource(imageStream, (String)ObjectUtils.defaultIfNull((Object)contentType, (Object)"image/jpeg"));
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        imgSource.setName(cid);
        return this.setAttachments(new DataSource[]{imgSource});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mail addImage(String cid, File imageFile) {
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream((File)imageFile);
            Mail mail = this.addImage(cid, in, FileTypeMap.getDefaultFileTypeMap().getContentType(imageFile));
            return mail;
        }
        finally {
            IOUtils.closeQuietly((Closeable)in);
        }
    }

    public Mail setCharset(Charset charset) {
        this.mailAccount.setCharset(charset);
        return this;
    }

    public Mail setUseGlobalSession(boolean isUseGlobalSession) {
        this.useGlobalSession = isUseGlobalSession;
        return this;
    }

    public String send() throws MailException {
        try {
            return this.doSend();
        }
        catch (MessagingException e) {
            throw new MailException(e);
        }
    }

    private String doSend() throws MessagingException {
        MimeMessage mimeMessage = this.buildMsg();
        Transport.send((Message)mimeMessage);
        return mimeMessage.getMessageID();
    }

    private MimeMessage buildMsg() throws MessagingException {
        Charset charset = this.mailAccount.getCharset();
        MimeMessage msg = new MimeMessage(this.getSession(this.useGlobalSession));
        String from = this.mailAccount.getFrom();
        if (StringUtils.isEmpty((CharSequence)from)) {
            msg.setFrom();
        } else {
            msg.setFrom((Address)InternalMailUtils.parseFirstAddress(from, charset));
        }
        msg.setSubject(this.title, charset.name());
        msg.setSentDate(new Date());
        msg.setContent(this.buildContent(charset));
        msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])InternalMailUtils.parseAddressFromStrs(this.tos, charset));
        if (ArrayUtils.isNotEmpty((Object[])this.ccs)) {
            msg.setRecipients(MimeMessage.RecipientType.CC, (Address[])InternalMailUtils.parseAddressFromStrs(this.ccs, charset));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.bccs)) {
            msg.setRecipients(MimeMessage.RecipientType.BCC, (Address[])InternalMailUtils.parseAddressFromStrs(this.bccs, charset));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.reply)) {
            msg.setReplyTo((Address[])InternalMailUtils.parseAddressFromStrs(this.reply, charset));
        }
        return msg;
    }

    private Multipart buildContent(Charset charset) throws MessagingException {
        MimeBodyPart body = new MimeBodyPart();
        body.setContent((Object)this.content, StringUtils.format((CharSequence)"text/{}; charset={}", (Object[])new Object[]{this.isHtml ? "html" : "plain", charset}));
        this.multipart.addBodyPart((BodyPart)body);
        return this.multipart;
    }

    private Session getSession(boolean isSingleton) {
        MailAccount mailAccount = this.mailAccount;
        UserPassAuthenticator authenticator = null;
        if (mailAccount.isAuth().booleanValue()) {
            authenticator = new UserPassAuthenticator(mailAccount.getUser(), mailAccount.getPass());
        }
        return isSingleton ? Session.getDefaultInstance((Properties)mailAccount.getSmtpProps(), authenticator) : Session.getInstance((Properties)mailAccount.getSmtpProps(), authenticator);
    }
}

