/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.extra.ftp;

import com.github.jarvisframework.tool.core.collection.CollectionUtils;
import com.github.jarvisframework.tool.core.io.FileUtils;
import com.github.jarvisframework.tool.core.util.CharsetUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.extra.ftp.FtpConfig;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;

public abstract class AbstractFtpClient
implements Closeable {
    public static final Charset DEFAULT_CHARSET = CharsetUtils.CHARSET_UTF_8;
    protected FtpConfig ftpConfig;

    protected AbstractFtpClient(FtpConfig config) {
        this.ftpConfig = config;
    }

    public abstract AbstractFtpClient reconnectIfTimeout();

    public abstract boolean cd(String var1);

    public boolean toParent() {
        return this.cd("..");
    }

    public abstract String pwd();

    public abstract boolean mkdir(String var1);

    public boolean exist(String path) {
        String fileName = FileUtils.getName((String)path);
        String dir = StringUtils.removeSuffix((CharSequence)path, (CharSequence)fileName);
        List<String> names = this.ls(dir);
        return AbstractFtpClient.containsIgnoreCase(names, fileName);
    }

    public abstract List<String> ls(String var1);

    public abstract boolean delFile(String var1);

    public abstract boolean delDir(String var1);

    public void mkDirs(String dir) {
        String[] dirs = StringUtils.trim((CharSequence)dir).split("[\\\\/]+");
        String now = this.pwd();
        if (dirs.length > 0 && StringUtils.isEmpty((CharSequence)dirs[0])) {
            this.cd("/");
        }
        for (String s : dirs) {
            if (!StringUtils.isNotEmpty((CharSequence)s) || this.cd(s)) continue;
            this.mkdir(s);
            this.cd(s);
        }
        this.cd(now);
    }

    public abstract boolean upload(String var1, File var2);

    public abstract void download(String var1, File var2);

    public abstract void recursiveDownloadFolder(String var1, File var2);

    private static boolean containsIgnoreCase(List<String> names, String nameToFind) {
        if (CollectionUtils.isEmpty(names)) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)nameToFind)) {
            return false;
        }
        for (String name : names) {
            if (!nameToFind.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

