/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.extra.ftp;

import com.github.jarvisframework.tool.core.collection.ListUtils;
import com.github.jarvisframework.tool.core.io.FileUtils;
import com.github.jarvisframework.tool.core.lang.Assert;
import com.github.jarvisframework.tool.core.lang.Filter;
import com.github.jarvisframework.tool.core.util.ArrayUtils;
import com.github.jarvisframework.tool.core.util.CharsetUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.extra.ftp.AbstractFtpClient;
import com.github.jarvisframework.tool.extra.ftp.FtpConfig;
import com.github.jarvisframework.tool.extra.ftp.FtpException;
import com.github.jarvisframework.tool.extra.ftp.FtpModeEnum;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpClient
extends AbstractFtpClient {
    public static final int DEFAULT_PORT = 21;
    private FTPClient client;
    private FtpModeEnum mode;
    private boolean backToPwd;

    public FtpClient(String host) {
        this(host, 21);
    }

    public FtpClient(String host, int port) {
        this(host, port, "anonymous", "");
    }

    public FtpClient(String host, int port, String user, String password) {
        this(host, port, user, password, CharsetUtils.CHARSET_UTF_8);
    }

    public FtpClient(String host, int port, String user, String password, Charset charset) {
        this(host, port, user, password, charset, null);
    }

    public FtpClient(String host, int port, String user, String password, FtpModeEnum mode) {
        this(host, port, user, password, CharsetUtils.CHARSET_UTF_8, mode);
    }

    public FtpClient(String host, int port, String user, String password, Charset charset, FtpModeEnum mode) {
        this(new FtpConfig(host, port, user, password, charset), mode);
    }

    public FtpClient(FtpConfig config, FtpModeEnum mode) {
        super(config);
        this.mode = mode;
        this.init();
    }

    public FtpClient init() {
        return this.init(this.ftpConfig, this.mode);
    }

    public FtpClient init(String host, int port, String user, String password) {
        return this.init(host, port, user, password, null);
    }

    public FtpClient init(String host, int port, String user, String password, FtpModeEnum mode) {
        return this.init(new FtpConfig(host, port, user, password, this.ftpConfig.getCharset()), mode);
    }

    public FtpClient init(FtpConfig config, FtpModeEnum mode) {
        FTPClient client = new FTPClient();
        client.setControlEncoding(config.getCharset().toString());
        client.setConnectTimeout((int)config.getConnectionTimeout());
        try {
            client.connect(config.getHost(), config.getPort());
            client.setSoTimeout((int)config.getSoTimeout());
            client.login(config.getUser(), config.getPassword());
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        int replyCode = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            try {
                client.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new FtpException("Login failed for user [{}], reply code is: [{}]", config.getUser(), replyCode);
        }
        this.client = client;
        if (mode != null) {
            this.setMode(mode);
        }
        return this;
    }

    public FtpClient setMode(FtpModeEnum mode) {
        this.mode = mode;
        switch (mode) {
            case Active: {
                this.client.enterLocalActiveMode();
                break;
            }
            case Passive: {
                this.client.enterLocalPassiveMode();
            }
        }
        return this;
    }

    public FtpClient setBackToPwd(boolean backToPwd) {
        this.backToPwd = backToPwd;
        return this;
    }

    @Override
    public FtpClient reconnectIfTimeout() {
        String pwd = null;
        try {
            pwd = this.pwd();
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
        if (pwd == null) {
            return this.init();
        }
        return this;
    }

    @Override
    public boolean cd(String directory) {
        if (StringUtils.isBlank((CharSequence)directory)) {
            return false;
        }
        try {
            return this.client.changeWorkingDirectory(directory);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public String pwd() {
        try {
            return this.client.printWorkingDirectory();
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public List<String> ls(String path) {
        FTPFile[] ftpFiles = this.lsFiles(path);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (FTPFile ftpFile : ftpFiles) {
            fileNames.add(ftpFile.getName());
        }
        return fileNames;
    }

    public List<FTPFile> lsFiles(String path, Filter<FTPFile> filter) {
        Object[] ftpFiles = this.lsFiles(path);
        if (ArrayUtils.isEmpty((Object[])ftpFiles)) {
            return ListUtils.empty();
        }
        ArrayList<FTPFile> result = new ArrayList<FTPFile>(ftpFiles.length - 2 <= 0 ? ftpFiles.length : ftpFiles.length - 2);
        for (Object ftpFile : ftpFiles) {
            String fileName = ftpFile.getName();
            if (StringUtils.equals((CharSequence)".", (CharSequence)fileName) || StringUtils.equals((CharSequence)"..", (CharSequence)fileName) || null != filter && !filter.accept(ftpFile)) continue;
            result.add((FTPFile)ftpFile);
        }
        return result;
    }

    public FTPFile[] lsFiles(String path) {
        FTPFile[] ftpFiles;
        String pwd = null;
        if (StringUtils.isNotBlank((CharSequence)path)) {
            pwd = this.pwd();
            this.cd(path);
        }
        try {
            ftpFiles = this.client.listFiles();
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        finally {
            this.cd(pwd);
        }
        return ftpFiles;
    }

    public String[] listNames() {
        try {
            return this.client.listNames();
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public boolean mkdir(String dir) {
        try {
            return this.client.makeDirectory(dir);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public boolean existFile(String path) {
        Object[] ftpFileArr;
        try {
            ftpFileArr = this.client.listFiles(path);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        return ArrayUtils.isNotEmpty((Object[])ftpFileArr);
    }

    @Override
    public boolean delFile(String path) {
        boolean isSuccess;
        String pwd = this.pwd();
        String fileName = FileUtils.getName((String)path);
        String dir = StringUtils.removeSuffix((CharSequence)path, (CharSequence)fileName);
        this.cd(dir);
        try {
            isSuccess = this.client.deleteFile(fileName);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        finally {
            this.cd(pwd);
        }
        return isSuccess;
    }

    @Override
    public boolean delDir(String dirPath) {
        FTPFile[] dirs;
        try {
            dirs = this.client.listFiles(dirPath);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        for (FTPFile ftpFile : dirs) {
            String name = ftpFile.getName();
            String childPath = StringUtils.format((CharSequence)"{}/{}", (Object[])new Object[]{dirPath, name});
            if (ftpFile.isDirectory()) {
                if (".".equals(name) || "..".equals(name)) continue;
                this.delDir(childPath);
                continue;
            }
            this.delFile(childPath);
        }
        try {
            return this.client.removeDirectory(dirPath);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public boolean upload(String destPath, File file) {
        Assert.notNull((Object)file, (String)"file to upload is null !", (Object[])new Object[0]);
        return this.upload(destPath, file.getName(), file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean upload(String path, String fileName, File file) {
        try (BufferedInputStream in = FileUtils.getInputStream((File)file);){
            boolean bl = this.upload(path, fileName, in);
            return bl;
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public boolean upload(String path, String fileName, InputStream fileStream) {
        boolean isOk;
        try {
            this.client.setFileType(2);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        String pwd = null;
        if (this.backToPwd) {
            pwd = this.pwd();
        }
        if (StringUtils.isNotBlank((CharSequence)path)) {
            this.mkDirs(path);
            isOk = this.cd(path);
            if (!isOk) {
                return false;
            }
        }
        try {
            isOk = this.client.storeFile(fileName, fileStream);
            return isOk;
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        finally {
            if (this.backToPwd) {
                this.cd(pwd);
            }
        }
    }

    @Override
    public void download(String path, File outFile) {
        String fileName = FileUtils.getName((String)path);
        String dir = StringUtils.removeSuffix((CharSequence)path, (CharSequence)fileName);
        this.download(dir, fileName, outFile);
    }

    @Override
    public void recursiveDownloadFolder(String sourcePath, File destDir) {
        for (FTPFile ftpFile : this.lsFiles(sourcePath, null)) {
            String fileName = ftpFile.getName();
            String srcFile = StringUtils.format((CharSequence)"{}/{}", (Object[])new Object[]{sourcePath, fileName});
            File destFile = FileUtils.file((File)destDir, (String)fileName);
            if (!ftpFile.isDirectory()) {
                if (FileUtils.exist((File)destFile) && ftpFile.getTimestamp().getTimeInMillis() <= destFile.lastModified()) continue;
                this.download(srcFile, destFile);
                continue;
            }
            FileUtils.mkdir((File)destFile);
            this.recursiveDownloadFolder(srcFile, destFile);
        }
    }

    public void download(String path, String fileName, File outFile) {
        if (outFile.isDirectory()) {
            outFile = new File(outFile, fileName);
        }
        if (!outFile.exists()) {
            FileUtils.touch((File)outFile);
        }
        try (BufferedOutputStream out = FileUtils.getOutputStream((File)outFile);){
            this.download(path, fileName, out);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public void download(String path, String fileName, OutputStream out) {
        String pwd = null;
        if (this.backToPwd) {
            pwd = this.pwd();
        }
        this.cd(path);
        try {
            this.client.setFileType(2);
            this.client.retrieveFile(fileName, out);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        finally {
            if (this.backToPwd) {
                this.cd(pwd);
            }
        }
    }

    public List<List<String>> downloadDataTableByTextFile(String path, String fileName, String splitStr) {
        InputStream is = this.downloadStream(path, fileName);
        if (null == is) {
            return new ArrayList<List<String>>();
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String[] table = new ArrayList();
        try {
            String[] cols;
            String len;
            while ((len = br.readLine()) != null) {
                cols = len.split(splitStr);
                ArrayList<String> line = new ArrayList<String>(cols.length);
                for (String col : cols) {
                    line.add(col);
                }
                table.add(line);
            }
            cols = table;
            return cols;
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                throw new FtpException(e);
            }
        }
    }

    public InputStream downloadStream(String path, String fileName) {
        String pwd = null;
        if (this.backToPwd) {
            pwd = this.pwd();
        }
        this.cd(path);
        try {
            InputStream is;
            this.client.setFileType(2);
            InputStream inputStream = is = this.client.retrieveFileStream(path + fileName);
            return inputStream;
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        finally {
            if (this.backToPwd) {
                this.cd(pwd);
            }
        }
    }

    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        if (null != this.client) {
            this.client.logout();
            if (this.client.isConnected()) {
                this.client.disconnect();
            }
            this.client = null;
        }
    }
}

