/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.extra.qimen;

import com.github.jarvisframework.tool.core.util.XmlParseUtils;
import com.github.jarvisframework.tool.extra.qimen.CheckResultDTO;
import com.github.jarvisframework.tool.extra.qimen.QimenException;
import com.github.jarvisframework.tool.http.HttpUtils;
import com.taobao.api.internal.spi.SpiUtils;
import com.taobao.api.internal.util.TaobaoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QimenUtils {
    private static final Log LOG = LogFactory.getLog(QimenUtils.class);

    public static String getRequestOrderNo(String method, String body) {
        switch (method) {
            case "singleitem.synchronize": {
                return QimenUtils.itemCodeOf(body);
            }
            case "stockout.create": {
                return QimenUtils.stockoutOrderCodeOf(body);
            }
            case "entryorder.create": {
                return QimenUtils.entryOrderCodeOf(body);
            }
            case "taobao.qimen.deliveryorder.confirm": {
                return QimenUtils.deliveryConfirmOrderCodeOf(body);
            }
        }
        return "";
    }

    public static final String itemCodeOf(String xmlStr) {
        return XmlParseUtils.getText((String)xmlStr, (String)"request/item/itemCode");
    }

    public static final String stockoutOrderCodeOf(String xmlStr) {
        return XmlParseUtils.getText((String)xmlStr, (String)"request/deliveryOrder/deliveryOrderCode");
    }

    public static final String entryOrderCodeOf(String xmlStr) {
        return XmlParseUtils.getText((String)xmlStr, (String)"request/entryOrder/entryOrderCode");
    }

    public static final String deliveryConfirmOrderCodeOf(String xmlStr) {
        return XmlParseUtils.getText((String)xmlStr, (String)"request/deliveryOrder/deliveryOrderCode");
    }

    public static final CheckResultDTO checkSign(HttpServletRequest request, String secret) throws IOException, QimenException {
        HashMap<String, String> params;
        CheckResultDTO result = new CheckResultDTO();
        String contentType = HttpUtils.getContentType((HttpServletRequest)request);
        String charset = HttpUtils.getResponseCharset((String)contentType);
        HashSet<String> contentTypes = new HashSet<String>();
        contentTypes.add("application/x-www-form-urlencoded");
        contentTypes.add("text/xml");
        contentTypes.add("application/xml");
        contentTypes.add("text/plain");
        contentTypes.add("application/json");
        if (contentTypes.contains(contentType)) {
            params = new HashMap<String, String>(9);
            Map headerMap = SpiUtils.getHeaderMap((HttpServletRequest)request, (String)charset);
            params.putAll(headerMap);
            if (null != request.getQueryString()) {
                Map queryMap = SpiUtils.getQueryMap((HttpServletRequest)request, (String)charset);
                params.putAll(queryMap);
            }
        } else {
            throw new QimenException("Unspported API request");
        }
        Map formMap = SpiUtils.getFormMap((HttpServletRequest)request, params);
        params.putAll(formMap);
        String body = HttpUtils.getStreamAsString((InputStream)request.getInputStream(), (String)charset);
        boolean valid = QimenUtils.checkSignInternal(params, body, secret, charset);
        result.setSuccess(valid);
        result.setRequestParams(params);
        result.setRequestBody(body);
        return result;
    }

    private static boolean checkSignInternal(Map<String, String> params, String body, String secret, String charset) throws IOException {
        String remoteSign = params.get("sign");
        params.remove("sign");
        String localSign = TaobaoUtils.signTopRequest(params, (String)body, (String)secret, (String)params.get("sign_method"));
        if (localSign.equals(remoteSign)) {
            return true;
        }
        String paramStr = QimenUtils.getParamStrFromMap(params);
        LOG.error((Object)("checkTopSign error^_^remoteSign=" + remoteSign + "^_^localSign=" + localSign + "^_^paramStr=" + paramStr + "^_^body=" + body));
        return false;
    }

    private static String getParamStrFromMap(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            Object[] keys = params.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object name : keys) {
                if ("sign".equals(name)) continue;
                sb.append((String)name);
                sb.append(params.get(name));
            }
        }
        return sb.toString();
    }

    public static boolean isErpCall(String method) {
        switch (method) {
            case "singleitem.synchronize": 
            case "entryorder.create": 
            case "returnorder.create": 
            case "stockout.create": 
            case "deliveryorder.batchcreate": 
            case "deliveryorder.create": 
            case "deliveryorder.batchcreate.answer": 
            case "orderprocess.query": 
            case "order.cancel": 
            case "inventory.query": 
            case "stock.query": {
                return true;
            }
        }
        return false;
    }

    public static boolean isWmsCall(String method) {
        switch (method) {
            case "taobao.qimen.deliveryorder.confirm": 
            case "taobao.qimen.deliveryorder.batchconfirm": 
            case "taobao.qimen.stockout.confirm": 
            case "taobao.qimen.returnorder.confirm": 
            case "taobao.qimen.entryorder.confirm": 
            case "taobao.qimen.orderprocess.report": 
            case "taobao.qimen.inventory.report": 
            case "taobao.qimen.stockchange.report": 
            case "taobao.qimen.sn.report": 
            case "taobao.qimen.order.cancel": 
            case "taobao.qimen.entryorder.query": 
            case "taobao.qimen.warehouse.query": {
                return true;
            }
        }
        return false;
    }
}

