/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.setting;

import com.github.jarvisframework.tool.core.bean.BeanUtils;
import com.github.jarvisframework.tool.core.bean.copier.CopyOptions;
import com.github.jarvisframework.tool.core.bean.copier.ValueProvider;
import com.github.jarvisframework.tool.core.convert.Convert;
import com.github.jarvisframework.tool.core.getter.OptNullBasicTypeFromStringGetter;
import com.github.jarvisframework.tool.core.util.ObjectUtils;
import com.github.jarvisframework.tool.core.util.ReflectUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.log.Log;
import com.github.jarvisframework.tool.log.LogFactory;
import java.io.Serializable;
import java.lang.reflect.Type;

public abstract class AbsSetting
implements OptNullBasicTypeFromStringGetter<String>,
Serializable {
    private static final long serialVersionUID = 6200156302595905863L;
    private static final Log log = LogFactory.get();
    public static final String DEFAULT_DELIMITER = ",";
    public static final String DEFAULT_GROUP = "";

    public String getString(String key, String defaultValue) {
        return this.getString(key, DEFAULT_GROUP, defaultValue);
    }

    public String getString(String key, String group, String defaultValue) {
        String value = this.getByGroup(key, group);
        return (String)ObjectUtils.defaultIfNull((Object)value, (Object)defaultValue);
    }

    public String getStrNotEmpty(String key, String group, String defaultValue) {
        String value = this.getByGroup(key, group);
        return (String)ObjectUtils.defaultIfEmpty((CharSequence)value, (CharSequence)defaultValue);
    }

    public abstract String getByGroup(String var1, String var2);

    public String getWithLog(String key) {
        String value = this.getString(key);
        if (value == null) {
            log.debug("No key define for [{}]!", new Object[]{key});
        }
        return value;
    }

    public String getByGroupWithLog(String key, String group) {
        String value = this.getByGroup(key, group);
        if (value == null) {
            log.debug("No key define for [{}] of group [{}] !", new Object[]{key, group});
        }
        return value;
    }

    public String[] getStrings(String key) {
        return this.getStrings(key, null);
    }

    public String[] getStringsWithDefault(String key, String[] defaultValue) {
        String[] value = this.getStrings(key, null);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getStrings(String key, String group) {
        return this.getStrings(key, group, DEFAULT_DELIMITER);
    }

    public String[] getStrings(String key, String group, String delimiter) {
        String value = this.getByGroup(key, group);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return StringUtils.split((CharSequence)value, (CharSequence)delimiter);
    }

    public Integer getInt(String key, String group) {
        return this.getInt(key, group, null);
    }

    public Integer getInt(String key, String group, Integer defaultValue) {
        return Convert.toInt((Object)this.getByGroup(key, group), (Integer)defaultValue);
    }

    public Boolean getBool(String key, String group) {
        return this.getBool(key, group, null);
    }

    public Boolean getBool(String key, String group, Boolean defaultValue) {
        return Convert.toBoolean((Object)this.getByGroup(key, group), (Boolean)defaultValue);
    }

    public Long getLong(String key, String group) {
        return this.getLong(key, group, null);
    }

    public Long getLong(String key, String group, Long defaultValue) {
        return Convert.toLong((Object)this.getByGroup(key, group), (Long)defaultValue);
    }

    public Character getChar(String key, String group) {
        String value = this.getByGroup(key, group);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Double getDouble(String key, String group) {
        return this.getDouble(key, group, null);
    }

    public Double getDouble(String key, String group, Double defaultValue) {
        return Convert.toDouble((Object)this.getByGroup(key, group), (Double)defaultValue);
    }

    public <T> T toBean(final String group, T bean) {
        return (T)BeanUtils.fillBean(bean, (ValueProvider)new ValueProvider<String>(){

            public Object value(String key, Type valueType) {
                return AbsSetting.this.getByGroup(key, group);
            }

            public boolean containsKey(String key) {
                return null != AbsSetting.this.getByGroup(key, group);
            }
        }, (CopyOptions)CopyOptions.create());
    }

    public <T> T toBean(String group, Class<T> beanClass) {
        return (T)this.toBean(group, ReflectUtils.newInstanceIfPossible(beanClass));
    }

    public <T> T toBean(T bean) {
        return this.toBean(null, bean);
    }

    public <T> T toBean(Class<T> beanClass) {
        return this.toBean((String)null, beanClass);
    }
}

