/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarvisframework.tool.setting.dialect;

import com.github.jarvisframework.tool.core.bean.BeanUtils;
import com.github.jarvisframework.tool.core.collection.CollectionUtils;
import com.github.jarvisframework.tool.core.convert.Convert;
import com.github.jarvisframework.tool.core.getter.BasicTypeGetter;
import com.github.jarvisframework.tool.core.getter.OptBasicTypeGetter;
import com.github.jarvisframework.tool.core.io.FileUtils;
import com.github.jarvisframework.tool.core.io.IORuntimeException;
import com.github.jarvisframework.tool.core.io.IOUtils;
import com.github.jarvisframework.tool.core.io.resource.ClassPathResource;
import com.github.jarvisframework.tool.core.io.resource.FileResource;
import com.github.jarvisframework.tool.core.io.resource.Resource;
import com.github.jarvisframework.tool.core.io.resource.UrlResource;
import com.github.jarvisframework.tool.core.io.watch.SimpleWatcher;
import com.github.jarvisframework.tool.core.io.watch.WatchMonitor;
import com.github.jarvisframework.tool.core.io.watch.WatchUtils;
import com.github.jarvisframework.tool.core.io.watch.Watcher;
import com.github.jarvisframework.tool.core.lang.Assert;
import com.github.jarvisframework.tool.core.util.CharsetUtils;
import com.github.jarvisframework.tool.core.util.ReflectUtils;
import com.github.jarvisframework.tool.core.util.ResourceUtils;
import com.github.jarvisframework.tool.core.util.StringUtils;
import com.github.jarvisframework.tool.log.StaticLog;
import com.github.jarvisframework.tool.setting.SettingRuntimeException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class MyProperties
extends Properties
implements BasicTypeGetter<String>,
OptBasicTypeGetter<String> {
    private static final long serialVersionUID = 1935981579709590740L;
    public static final String EXT_NAME = "properties";
    private URL propertiesFileUrl;
    private WatchMonitor watchMonitor;
    private Charset charset = CharsetUtils.CHARSET_ISO_8859_1;

    public static MyProperties getProperties(String resource) {
        return new MyProperties(resource);
    }

    public static MyProperties getProp(String resource, String charsetName) {
        return new MyProperties(resource, charsetName);
    }

    public static MyProperties getProp(String resource, Charset charset) {
        return new MyProperties(resource, charset);
    }

    public MyProperties() {
    }

    public MyProperties(String path) {
        this(path, CharsetUtils.CHARSET_ISO_8859_1);
    }

    public MyProperties(String path, String charsetName) {
        this(path, CharsetUtils.charset((String)charsetName));
    }

    public MyProperties(String path, Charset charset) {
        Assert.notBlank((CharSequence)path, (String)"Blank properties file path !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(ResourceUtils.getResourceObj((String)path));
    }

    public MyProperties(File propertiesFile) {
        this(propertiesFile, StandardCharsets.ISO_8859_1);
    }

    public MyProperties(File propertiesFile, String charsetName) {
        this(propertiesFile, Charset.forName(charsetName));
    }

    public MyProperties(File propertiesFile, Charset charset) {
        Assert.notNull((Object)propertiesFile, (String)"Null properties file!", (Object[])new Object[0]);
        this.charset = charset;
        this.load((Resource)new FileResource(propertiesFile));
    }

    public MyProperties(String path, Class<?> clazz) {
        this(path, clazz, "ISO-8859-1");
    }

    public MyProperties(String path, Class<?> clazz, String charsetName) {
        this(path, clazz, CharsetUtils.charset((String)charsetName));
    }

    public MyProperties(String path, Class<?> clazz, Charset charset) {
        Assert.notBlank((CharSequence)path, (String)"Blank properties file path !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load((Resource)new ClassPathResource(path, clazz));
    }

    public MyProperties(URL propertiesUrl) {
        this(propertiesUrl, StandardCharsets.ISO_8859_1);
    }

    public MyProperties(URL propertiesUrl, String charsetName) {
        this(propertiesUrl, CharsetUtils.charset((String)charsetName));
    }

    public MyProperties(URL propertiesUrl, Charset charset) {
        Assert.notNull((Object)propertiesUrl, (String)"Null properties URL !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load((Resource)new UrlResource(propertiesUrl));
    }

    public MyProperties(MyProperties properties) {
        if (CollectionUtils.isNotEmpty((Map)properties)) {
            this.putAll((Map<?, ?>)properties);
        }
    }

    public void load(Resource urlResource) {
        this.propertiesFileUrl = urlResource.getUrl();
        if (null == this.propertiesFileUrl) {
            throw new SettingRuntimeException("Can not find properties file: [{}]", urlResource);
        }
        try (BufferedReader reader = urlResource.getReader(this.charset);){
            super.load(reader);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public void load() {
        this.load((Resource)new UrlResource(this.propertiesFileUrl));
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            Assert.notNull((Object)this.propertiesFileUrl, (String)"Properties URL is null !", (Object[])new Object[0]);
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            this.watchMonitor = WatchUtils.createModify((URL)this.propertiesFileUrl, (Watcher)new SimpleWatcher(){

                public void onModify(WatchEvent<?> event, Path currentPath) {
                    MyProperties.this.load();
                }
            });
            this.watchMonitor.start();
        } else {
            IOUtils.closeQuietly((Closeable)this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    public Object getObject(String key, Object defaultValue) {
        return this.getString(key, null == defaultValue ? null : defaultValue.toString());
    }

    public Object getObject(String key) {
        return this.getObject(key, null);
    }

    public String getString(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }

    public String getString(String key) {
        return super.getProperty(key);
    }

    public Integer getInt(String key, Integer defaultValue) {
        return Convert.toInt((Object)this.getString(key), (Integer)defaultValue);
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return Convert.toBoolean((Object)this.getString(key), (Boolean)defaultValue);
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        return Convert.toLong((Object)this.getString(key), (Long)defaultValue);
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Character getChar(String key, Character defaultValue) {
        String value = this.getString(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Character getChar(String key) {
        return this.getChar(key, null);
    }

    public Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public Float getFloat(String key, Float defaultValue) {
        return Convert.toFloat((Object)this.getString(key), (Float)defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) throws NumberFormatException {
        return Convert.toDouble((Object)this.getString(key), (Double)defaultValue);
    }

    public Double getDouble(String key) throws NumberFormatException {
        return this.getDouble(key, null);
    }

    public Short getShort(String key, Short defaultValue) {
        return Convert.toShort((Object)this.getString(key), (Short)defaultValue);
    }

    public Short getShort(String key) {
        return this.getShort(key, null);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return Convert.toByte((Object)this.getString(key), (Byte)defaultValue);
    }

    public Byte getByte(String key) {
        return this.getByte(key, null);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        String valueStr = this.getString(key);
        if (StringUtils.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, null);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        String valueStr = this.getString(key);
        if (StringUtils.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public BigInteger getBigInteger(String key) {
        return this.getBigInteger(key, null);
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key, E defaultValue) {
        return (E)Convert.toEnum(clazz, (Object)this.getString(key), defaultValue);
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        return this.getEnum(clazz, key, null);
    }

    public Date getDate(String key, Date defaultValue) {
        return Convert.toDate((Object)this.getString(key), (Date)defaultValue);
    }

    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    public String getAndRemoveStr(String ... keys) {
        String key;
        Object value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return (String)value;
    }

    public <T> T toBean(Class<T> beanClass) {
        return this.toBean(beanClass, null);
    }

    public <T> T toBean(Class<T> beanClass, String prefix) {
        Object bean = ReflectUtils.newInstanceIfPossible(beanClass);
        return (T)this.fillBean(bean, prefix);
    }

    public <T> T fillBean(T bean, String prefix) {
        prefix = StringUtils.nullToEmpty((CharSequence)StringUtils.addSuffixIfNot((CharSequence)prefix, (CharSequence)"."));
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!StringUtils.startWith((CharSequence)key, (CharSequence)prefix)) continue;
            try {
                BeanUtils.setProperty(bean, (String)StringUtils.subSuf((CharSequence)key, (int)prefix.length()), (Object)entry.getValue());
            }
            catch (Exception e) {
                StaticLog.debug((String)"Ignore property: [{}]", (Object[])new Object[]{key});
            }
        }
        return bean;
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, value.toString());
    }

    public void store(String absolutePath) throws IORuntimeException {
        BufferedWriter writer = null;
        try {
            writer = FileUtils.getWriter((String)absolutePath, (Charset)this.charset, (boolean)false);
            super.store(writer, null);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException((Throwable)e, "Store properties to [{}] error!", new Object[]{absolutePath});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)writer);
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileUtils.getAbsolutePath((String)path, clazz));
    }
}

