/*
 * Decompiled with CFR 0.152.
 */
package jasarus.di.spring;

import jasarus.di.api.NoSuchDependencyException;
import jasarus.di.spi.DependenciesRegistry;
import jasarus.di.spring.StaticApplicationContextLocator;
import java.util.Iterator;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SpringDependenciesRegistry
implements DependenciesRegistry {
    private final ApplicationContext applicationContext = this.resolveApplicationContext();

    public <T> T lookup(Class<T> type, String qualifier) {
        try {
            return (T)this.applicationContext.getBean(qualifier, type);
        }
        catch (BeansException e) {
            throw new NoSuchDependencyException();
        }
    }

    public <T> T lookup(Class<T> type) {
        Iterator beansOfType = this.applicationContext.getBeansOfType(type).values().iterator();
        if (!beansOfType.hasNext()) {
            throw new NoSuchDependencyException();
        }
        try {
            return (T)beansOfType.next();
        }
        catch (BeansException e) {
            throw new NoSuchDependencyException();
        }
    }

    public void injectInto(Object bean) {
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean(bean);
    }

    public void shutdown() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).close();
        }
    }

    private ApplicationContext resolveApplicationContext() {
        ApplicationContext applicationContext = StaticApplicationContextLocator.applicationContext();
        if (applicationContext != null) {
            return applicationContext;
        }
        try {
            Class<?> bootstrapConfiguration = Class.forName("jasarus.di.spring.SpringBootstrap");
            return new AnnotationConfigApplicationContext(new Class[]{bootstrapConfiguration});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

