/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.util;

import io.netty.buffer.ByteBuf;

public class BufferDumper {
    public static String dumpAsHex(ByteBuf buffer) {
        int i;
        int length = buffer.readableBytes();
        byte[] byteBuffer = new byte[length];
        buffer.markReaderIndex();
        buffer.readBytes(byteBuffer);
        buffer.resetReaderIndex();
        StringBuilder outputBuf = new StringBuilder(length * 4);
        int p = 0;
        int rows = length / 8;
        for (int i2 = 0; i2 < rows && p < length; ++i2) {
            int j;
            int ptemp = p;
            outputBuf.append(i2 + ": ");
            for (j = 0; j < 8; ++j) {
                String hexVal = Integer.toHexString(byteBuffer[ptemp] & 0xFF);
                if (hexVal.length() == 1) {
                    hexVal = "0" + hexVal;
                }
                outputBuf.append(hexVal + " ");
                ++ptemp;
            }
            outputBuf.append("    ");
            for (j = 0; j < 8; ++j) {
                int b = 0xFF & byteBuffer[p];
                if (b > 32 && b < 127) {
                    outputBuf.append((char)b + " ");
                } else {
                    outputBuf.append(". ");
                }
                ++p;
            }
            outputBuf.append("\n");
        }
        outputBuf.append(rows + ": ");
        int n = 0;
        for (i = p; i < length; ++i) {
            String hexVal = Integer.toHexString(byteBuffer[i] & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            outputBuf.append(hexVal + " ");
            ++n;
        }
        for (i = n; i < 8; ++i) {
            outputBuf.append("   ");
        }
        outputBuf.append("    ");
        for (i = p; i < length; ++i) {
            int b = 0xFF & byteBuffer[i];
            if (b > 32 && b < 127) {
                outputBuf.append((char)b + " ");
                continue;
            }
            outputBuf.append(". ");
        }
        outputBuf.append("\n");
        outputBuf.append("Total " + byteBuffer.length + " bytes read\n");
        return outputBuf.toString();
    }
}

