/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db;

import com.github.jasync.sql.db.Credentials;
import com.github.jasync.sql.db.CredentialsProvider;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/github/jasync/sql/db/StaticCredentialsProvider;", "Lcom/github/jasync/sql/db/CredentialsProvider;", "username", "", "password", "(Ljava/lang/String;Ljava/lang/String;)V", "getPassword", "()Ljava/lang/String;", "getUsername", "equals", "", "other", "", "hashCode", "", "provide", "Ljava/util/concurrent/CompletionStage;", "Lcom/github/jasync/sql/db/Credentials;", "toString", "jasync-common"})
public final class StaticCredentialsProvider
implements CredentialsProvider {
    @NotNull
    private final String username;
    @Nullable
    private final String password;

    public StaticCredentialsProvider(@NotNull String username, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this.username = username;
        this.password = password;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    @Override
    @NotNull
    public CompletionStage<Credentials> provide() {
        CompletableFuture<Credentials> completableFuture = CompletableFuture.completedFuture(new Credentials(this.username, this.password));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Credentials(username, password))");
        return completableFuture;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.github.jasync.sql.db.StaticCredentialsProvider");
        }
        StaticCredentialsProvider cfr_ignored_0 = (StaticCredentialsProvider)object2;
        if (!Intrinsics.areEqual((Object)this.username, (Object)((StaticCredentialsProvider)other).username)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.password, (Object)((StaticCredentialsProvider)other).password);
    }

    public int hashCode() {
        int result = this.username.hashCode();
        String string = this.password;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        return "StaticCredentialsProvider(username='" + this.username + "', password=***)";
    }
}

